/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;

public class ReleasableByteArray
implements ByteArray {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ReleasableByteArray.class);
    private final ReleasableBytesReference ref;

    ReleasableByteArray(StreamInput in) throws IOException {
        this.ref = in.readReleasableBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBytesReference(this.ref);
    }

    @Override
    public long size() {
        return this.ref.length() / 1;
    }

    @Override
    public byte get(long index) {
        assert (BigArrays.indexIsInt(index));
        return this.ref.get((int)index);
    }

    @Override
    public boolean get(long index, int len, BytesRef ref) {
        assert (BigArrays.indexIsInt(index));
        ReleasableBytesReference sliced = this.ref.slice((int)index, len);
        if (sliced.length() != 0) {
            ref.offset = sliced.arrayOffset();
            ref.length = sliced.length();
            ref.bytes = sliced.array();
            return true;
        }
        return false;
    }

    @Override
    public void set(long index, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(long fromIndex, long toIndex, byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasArray() {
        return this.ref.hasArray();
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BytesRefIterator iterator() {
        assert (this.ref.hasReferences());
        return this.ref.iterator();
    }

    @Override
    public void fillWith(InputStream in) {
        throw new UnsupportedOperationException("read-only ByteArray");
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE;
    }

    public void close() {
        this.ref.decRef();
    }
}

