/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.core.Releasable;

public final class SecureString
implements CharSequence,
Releasable {
    private char[] chars;

    public SecureString(char[] chars) {
        this.chars = Objects.requireNonNull(chars);
    }

    @Deprecated
    public SecureString(String s) {
        this(s.toCharArray());
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof CharSequence) {
            CharSequence cs = (CharSequence)o;
            return this.equals(cs);
        }
        return false;
    }

    public synchronized boolean equals(CharSequence that) {
        this.ensureNotClosed();
        return that != null && this.compareChars(0, that, 0, that.length()) && this.length() == that.length();
    }

    public boolean startsWith(CharSequence other) {
        this.ensureNotClosed();
        return this.compareChars(0, other, 0, other.length());
    }

    public synchronized boolean regionMatches(int thisOffset, CharSequence other, int otherOffset, int len) {
        this.ensureNotClosed();
        if (otherOffset < 0 || thisOffset < 0) {
            return false;
        }
        if ((long)otherOffset + (long)len > (long)other.length()) {
            return false;
        }
        if (len < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        if (len == 0) {
            return true;
        }
        return this.compareChars(thisOffset, other, otherOffset, len);
    }

    private boolean compareChars(int thisOffset, CharSequence other, int otherOffset, int len) {
        assert (len <= other.length()) : "len is longer that comparison string: " + len + " vs " + other.length();
        int equals = 0;
        for (int i = 0; i < len; ++i) {
            char o = other.charAt(otherOffset + i);
            int t = thisOffset + i < this.chars.length ? this.chars[thisOffset + i] : 65536;
            equals |= t ^ o;
        }
        return equals == 0;
    }

    public synchronized int hashCode() {
        return Arrays.hashCode(this.chars);
    }

    @Override
    public synchronized int length() {
        this.ensureNotClosed();
        return this.chars.length;
    }

    @Override
    public synchronized char charAt(int index) {
        this.ensureNotClosed();
        return this.chars[index];
    }

    @Override
    public SecureString subSequence(int start, int end) {
        throw new UnsupportedOperationException("Cannot get subsequence of SecureString");
    }

    @Override
    public synchronized String toString() {
        return new String(this.chars);
    }

    public synchronized void close() {
        if (this.chars != null) {
            Arrays.fill(this.chars, '\u0000');
            this.chars = null;
        }
    }

    public synchronized SecureString clone() {
        this.ensureNotClosed();
        return new SecureString(Arrays.copyOf(this.chars, this.chars.length));
    }

    public synchronized char[] getChars() {
        this.ensureNotClosed();
        return this.chars;
    }

    private void ensureNotClosed() {
        if (this.chars == null) {
            throw new IllegalStateException("SecureString has already been closed");
        }
    }
}

