/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.local.LocalClusterStateRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class GetPipelineRequest
extends LocalClusterStateRequest {
    private final String[] ids;
    private final boolean summary;

    public GetPipelineRequest(TimeValue masterNodeTimeout, boolean summary, String ... ids) {
        super(masterNodeTimeout);
        if (ids == null) {
            throw new IllegalArgumentException("ids cannot be null");
        }
        this.ids = ids;
        this.summary = summary;
    }

    public GetPipelineRequest(TimeValue masterNodeTimeout, String ... ids) {
        this(masterNodeTimeout, false, ids);
    }

    public GetPipelineRequest(StreamInput in) throws IOException {
        super(in);
        this.ids = in.readStringArray();
        this.summary = in.readBoolean();
    }

    public String[] getIds() {
        return this.ids;
    }

    public boolean isSummary() {
        return this.summary;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers);
    }
}

