/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.sampling.GetSampleStatsAction;
import org.elasticsearch.action.admin.indices.sampling.SamplingConfiguration;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.ingest.SamplingService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetSampleStatsAction
extends TransportNodesAction<GetSampleStatsAction.Request, GetSampleStatsAction.Response, GetSampleStatsAction.NodeRequest, GetSampleStatsAction.NodeResponse, Void> {
    private final SamplingService samplingService;
    private final ProjectResolver projectResolver;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportGetSampleStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, SamplingService samplingService, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/sample/stats", clusterService, transportService, actionFilters, GetSampleStatsAction.NodeRequest::new, threadPool.executor("management"));
        this.samplingService = samplingService;
        this.projectResolver = projectResolver;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    @Override
    protected Void createActionContext(Task task, GetSampleStatsAction.Request request) {
        String indexName = request.indices()[0];
        SamplingConfiguration samplingConfiguration = this.samplingService.getSamplingConfiguration(this.projectResolver.getProjectMetadata(this.clusterService.state()), request.indices()[0]);
        if (samplingConfiguration == null) {
            throw new ResourceNotFoundException("No sampling configuration found for [" + indexName + "]", new Object[0]);
        }
        return null;
    }

    @Override
    protected GetSampleStatsAction.Response newResponse(GetSampleStatsAction.Request request, List<GetSampleStatsAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), (IndicesRequest)request);
        SamplingConfiguration samplingConfiguration = this.samplingService.getSamplingConfiguration(this.projectResolver.getProjectMetadata(this.clusterService.state()), request.indices()[0]);
        int maxSamples = samplingConfiguration == null ? 0 : samplingConfiguration.maxSamples();
        return new GetSampleStatsAction.Response(this.clusterService.getClusterName(), nodeResponses, failures, maxSamples);
    }

    @Override
    protected GetSampleStatsAction.NodeRequest newNodeRequest(GetSampleStatsAction.Request request) {
        return new GetSampleStatsAction.NodeRequest(request.indices()[0]);
    }

    @Override
    protected GetSampleStatsAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new GetSampleStatsAction.NodeResponse(in);
    }

    @Override
    protected GetSampleStatsAction.NodeResponse nodeOperation(GetSampleStatsAction.NodeRequest request, Task task) {
        SamplingService.SampleStats sampleStats = this.samplingService.getLocalSampleStats(this.projectResolver.getProjectId(), request.getIndexName());
        return new GetSampleStatsAction.NodeResponse(this.transportService.getLocalNode(), sampleStats);
    }
}

