/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;

public record ResolvedIndexExpression(String original, LocalExpressions localExpressions, Set<String> remoteExpressions) implements Writeable
{
    public ResolvedIndexExpression(StreamInput in) throws IOException {
        this(in.readString(), new LocalExpressions(in), in.readCollectionAsImmutableSet(StreamInput::readString));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.original);
        this.localExpressions.writeTo(out);
        out.writeStringCollection(this.remoteExpressions);
    }

    public record LocalExpressions(Set<String> indices, LocalIndexResolutionResult localIndexResolutionResult, @Nullable ElasticsearchException exception) implements Writeable
    {
        public static final LocalExpressions NONE = new LocalExpressions(Set.of(), LocalIndexResolutionResult.NONE, null);

        public LocalExpressions {
            assert (localIndexResolutionResult != LocalIndexResolutionResult.SUCCESS || exception == null) : "If the local resolution result is SUCCESS, exception must be null";
        }

        public LocalExpressions(StreamInput in) throws IOException {
            this(in.readCollectionAsImmutableSet(StreamInput::readString), in.readEnum(LocalIndexResolutionResult.class), (ElasticsearchException)ElasticsearchException.readException(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringCollection(this.indices);
            out.writeEnum(this.localIndexResolutionResult);
            ElasticsearchException.writeException(this.exception, out);
        }
    }

    public static enum LocalIndexResolutionResult {
        NONE,
        SUCCESS,
        CONCRETE_RESOURCE_NOT_VISIBLE,
        CONCRETE_RESOURCE_UNAUTHORIZED;

    }
}

