/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.datastreams.UpdateDataStreamSettingsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.CountDownActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateDataStreamSettingsAction
extends TransportMasterNodeAction<UpdateDataStreamSettingsAction.Request, UpdateDataStreamSettingsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateDataStreamSettingsAction.class);
    private static final Set<String> APPLY_TO_WRITE_INDEX = Set.of("index.number_of_replicas");
    private static final Set<String> APPLY_TO_ALL_BACKING_INDICES = Set.of("index.lifecycle.name", "index.lifecycle.prefer_ilm", "index.refresh_interval");
    private static final Set<String> APPLY_TO_DATA_STREAM_ONLY = Set.of("index.number_of_shards");
    private final MetadataDataStreamsService metadataDataStreamsService;
    private final MetadataUpdateSettingsService updateSettingsService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final SystemIndices systemIndices;
    private final ProjectResolver projectResolver;
    private final SettingsFilter settingsFilter;

    @Inject
    public TransportUpdateDataStreamSettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, MetadataDataStreamsService metadataDataStreamsService, MetadataUpdateSettingsService updateSettingsService, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices, SettingsFilter settingsFilter) {
        super("indices:admin/data_stream/settings/update", transportService, clusterService, threadPool, actionFilters, UpdateDataStreamSettingsAction.Request::new, UpdateDataStreamSettingsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.projectResolver = projectResolver;
        this.metadataDataStreamsService = metadataDataStreamsService;
        this.updateSettingsService = updateSettingsService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.systemIndices = systemIndices;
        this.settingsFilter = settingsFilter;
    }

    protected void masterOperation(Task task, UpdateDataStreamSettingsAction.Request request, ClusterState state, ActionListener<UpdateDataStreamSettingsAction.Response> listener) throws Exception {
        List dataStreamNames = this.indexNameExpressionResolver.dataStreamNames(this.clusterService.state(), IndicesOptions.DEFAULT, request.indices());
        ArrayList dataStreamSettingsResponse = new ArrayList();
        CountDownActionListener countDownListener = new CountDownActionListener(dataStreamNames.size() + 1, listener.delegateFailure((responseActionListener, unused) -> responseActionListener.onResponse((Object)new UpdateDataStreamSettingsAction.Response(dataStreamSettingsResponse))));
        countDownListener.onResponse(null);
        for (String dataStreamName : dataStreamNames) {
            this.updateSingleDataStream(dataStreamName, request.getSettings(), request.isDryRun(), request.masterNodeTimeout(), request.ackTimeout(), (ActionListener<UpdateDataStreamSettingsAction.DataStreamSettingsResponse>)ActionListener.wrap(dataStreamResponse -> {
                dataStreamSettingsResponse.add(dataStreamResponse);
                countDownListener.onResponse(null);
            }, e -> {
                dataStreamSettingsResponse.add(new UpdateDataStreamSettingsAction.DataStreamSettingsResponse(dataStreamName, false, Strings.hasText((String)e.getMessage()) ? e.getMessage() : e.toString(), Settings.EMPTY, Settings.EMPTY, UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndicesSettingsResult.EMPTY));
                countDownListener.onResponse(null);
            }));
        }
    }

    private void updateSingleDataStream(String dataStreamName, Settings settingsOverrides, boolean dryRun, TimeValue masterNodeTimeout, TimeValue ackTimeout, ActionListener<UpdateDataStreamSettingsAction.DataStreamSettingsResponse> listener) {
        logger.debug("updating settings for {}", (Object)dataStreamName);
        HashSet<String> settingsToReject = new HashSet<String>();
        for (String settingName : settingsOverrides.keySet()) {
            if (APPLY_TO_WRITE_INDEX.contains(settingName) || APPLY_TO_ALL_BACKING_INDICES.contains(settingName) || APPLY_TO_DATA_STREAM_ONLY.contains(settingName)) continue;
            settingsToReject.add(settingName);
        }
        if (!settingsToReject.isEmpty()) {
            listener.onResponse((Object)new UpdateDataStreamSettingsAction.DataStreamSettingsResponse(dataStreamName, false, Strings.format((String)"Cannot set the following settings on a data stream: [%s]", (Object[])new Object[]{String.join((CharSequence)",", settingsToReject)}), Settings.EMPTY, Settings.EMPTY, UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndicesSettingsResult.EMPTY));
            return;
        }
        if (this.systemIndices.isSystemDataStream(dataStreamName)) {
            listener.onResponse((Object)new UpdateDataStreamSettingsAction.DataStreamSettingsResponse(dataStreamName, false, "Cannot update a system data stream", Settings.EMPTY, Settings.EMPTY, UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndicesSettingsResult.EMPTY));
            return;
        }
        this.metadataDataStreamsService.updateSettings(this.projectResolver.getProjectId(), masterNodeTimeout, ackTimeout, dataStreamName, settingsOverrides, dryRun, listener.delegateFailure((dataStreamSettingsResponseActionListener, dataStream) -> {
            if (dataStream != null) {
                this.updateSettingsOnIndices((DataStream)dataStream, settingsOverrides, dryRun, masterNodeTimeout, ackTimeout, listener);
            } else {
                dataStreamSettingsResponseActionListener.onResponse((Object)new UpdateDataStreamSettingsAction.DataStreamSettingsResponse(dataStreamName, false, "Updating settings not accepted for unknown reasons", Settings.EMPTY, Settings.EMPTY, UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndicesSettingsResult.EMPTY));
            }
        }));
    }

    private void updateSettingsOnIndices(DataStream dataStream, Settings requestSettings, boolean dryRun, TimeValue masterNodeTimeout, TimeValue ackTimeout, ActionListener<UpdateDataStreamSettingsAction.DataStreamSettingsResponse> listener) {
        HashMap<String, String> settingsToApplyToNonWriteIndices = new HashMap<String, String>();
        HashMap<String, String> settingsToApplyToWriteIndex = new HashMap<String, String>();
        ArrayList<String> appliedToDataStreamOnly = new ArrayList<String>();
        ArrayList<String> appliedToDataStreamAndWriteIndexOnly = new ArrayList<String>();
        ArrayList<String> appliedToDataStreamAndBackingIndices = new ArrayList<String>();
        Settings effectiveSettings = dataStream.getEffectiveSettings(this.projectResolver.getProjectMetadata(this.clusterService.state()));
        for (String settingName : requestSettings.keySet()) {
            if (APPLY_TO_WRITE_INDEX.contains(settingName)) {
                settingsToApplyToWriteIndex.put(settingName, effectiveSettings.get(settingName));
                appliedToDataStreamAndWriteIndexOnly.add(settingName);
                continue;
            }
            if (APPLY_TO_ALL_BACKING_INDICES.contains(settingName)) {
                settingsToApplyToWriteIndex.put(settingName, effectiveSettings.get(settingName));
                settingsToApplyToNonWriteIndices.put(settingName, effectiveSettings.get(settingName));
                appliedToDataStreamAndBackingIndices.add(settingName);
                continue;
            }
            if (!APPLY_TO_DATA_STREAM_ONLY.contains(settingName)) continue;
            appliedToDataStreamOnly.add(settingName);
        }
        List concreteIndices = dataStream.getIndices();
        Index writeIndex = dataStream.getWriteIndex();
        ArrayList indexSettingErrors = new ArrayList();
        CountDownActionListener indexCountDownListener = new CountDownActionListener(concreteIndices.size() + 1, listener.delegateFailure((dataStreamSettingsResponseActionListener, unused) -> dataStreamSettingsResponseActionListener.onResponse((Object)new UpdateDataStreamSettingsAction.DataStreamSettingsResponse(dataStream.getName(), true, null, this.settingsFilter.filter(dataStream.getSettings()), this.settingsFilter.filter(effectiveSettings), new UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndicesSettingsResult(appliedToDataStreamOnly, appliedToDataStreamAndWriteIndexOnly, appliedToDataStreamAndBackingIndices, indexSettingErrors)))));
        indexCountDownListener.onResponse(null);
        Settings applyToNonWriteIndexSettings = Settings.builder().loadFromMap(settingsToApplyToNonWriteIndices).build();
        Settings applyToWriteIndexSettings = Settings.builder().loadFromMap(settingsToApplyToWriteIndex).build();
        for (Index index : concreteIndices) {
            Settings settings = index.equals((Object)writeIndex) ? applyToWriteIndexSettings : applyToNonWriteIndexSettings;
            this.updateSettingsOnSingleIndex(index, settings, dryRun, masterNodeTimeout, ackTimeout, (ActionListener<UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndexSettingError>)indexCountDownListener.delegateFailure((listener1, indexSettingError) -> {
                if (indexSettingError != null) {
                    indexSettingErrors.add(indexSettingError);
                }
                listener1.onResponse(null);
            }));
        }
    }

    private void updateSettingsOnSingleIndex(Index index, Settings requestSettings, boolean dryRun, TimeValue masterNodeTimeout, TimeValue ackTimeout, ActionListener<UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndexSettingError> listener) {
        if (requestSettings.isEmpty()) {
            listener.onResponse(null);
        } else {
            ProjectMetadata projectMetadata = this.projectResolver.getProjectMetadata(this.clusterService.state());
            ClusterBlockException blockException = this.clusterService.state().blocks().indicesBlockedException(projectMetadata.id(), ClusterBlockLevel.METADATA_WRITE, new String[]{index.getName()});
            if (blockException != null) {
                listener.onResponse((Object)new UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndexSettingError(index.getName(), blockException.getMessage()));
                return;
            }
            if (dryRun) {
                listener.onResponse(null);
            } else {
                this.updateSettingsService.updateSettings(new UpdateSettingsClusterStateUpdateRequest(this.projectResolver.getProjectId(), masterNodeTimeout, ackTimeout, requestSettings, UpdateSettingsClusterStateUpdateRequest.OnExisting.OVERWRITE, UpdateSettingsClusterStateUpdateRequest.OnStaticSetting.REOPEN_INDICES, new Index[]{index}), ActionListener.wrap(response -> {
                    UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndexSettingError error = !response.isAcknowledged() ? new UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndexSettingError(index.getName(), "Updating settings not acknowledged for unknown reason") : null;
                    listener.onResponse(error);
                }, e -> listener.onResponse((Object)new UpdateDataStreamSettingsAction.DataStreamSettingsResponse.IndexSettingError(index.getName(), e.getMessage()))));
            }
        }
    }

    protected ClusterBlockException checkBlock(UpdateDataStreamSettingsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE);
    }
}

