/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.datastreams.UpdateDataStreamMappingsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.CountDownActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateDataStreamMappingsAction
extends TransportMasterNodeAction<UpdateDataStreamMappingsAction.Request, UpdateDataStreamMappingsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpdateDataStreamMappingsAction.class);
    private final MetadataDataStreamsService metadataDataStreamsService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final SystemIndices systemIndices;
    private final ProjectResolver projectResolver;
    private final IndicesService indicesService;

    @Inject
    public TransportUpdateDataStreamMappingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, MetadataDataStreamsService metadataDataStreamsService, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices, IndicesService indicesService) {
        super("indices:admin/data_stream/mappings/update", transportService, clusterService, threadPool, actionFilters, UpdateDataStreamMappingsAction.Request::new, UpdateDataStreamMappingsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.projectResolver = projectResolver;
        this.metadataDataStreamsService = metadataDataStreamsService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.systemIndices = systemIndices;
        this.indicesService = indicesService;
    }

    protected void masterOperation(Task task, UpdateDataStreamMappingsAction.Request request, ClusterState state, ActionListener<UpdateDataStreamMappingsAction.Response> listener) throws Exception {
        ProjectId projectId = this.projectResolver.getProjectId();
        List dataStreamNames = this.indexNameExpressionResolver.dataStreamNames(state.metadata().getProject(projectId), IndicesOptions.DEFAULT, request.indices());
        ArrayList dataStreamMappingsResponse = new ArrayList();
        CountDownActionListener countDownListener = new CountDownActionListener(dataStreamNames.size() + 1, listener.delegateFailure((responseActionListener, unused) -> responseActionListener.onResponse((Object)new UpdateDataStreamMappingsAction.Response(dataStreamMappingsResponse))));
        countDownListener.onResponse(null);
        for (String dataStreamName : dataStreamNames) {
            this.updateSingleDataStream(projectId, dataStreamName, request.getMappings(), request.masterNodeTimeout(), request.ackTimeout(), request.isDryRun(), (ActionListener<UpdateDataStreamMappingsAction.DataStreamMappingsResponse>)ActionListener.wrap(dataStreamResponse -> {
                dataStreamMappingsResponse.add(dataStreamResponse);
                countDownListener.onResponse(null);
            }, e -> {
                dataStreamMappingsResponse.add(new UpdateDataStreamMappingsAction.DataStreamMappingsResponse(dataStreamName, false, Strings.hasText((String)e.getMessage()) ? e.getMessage() : e.toString(), Mapping.EMPTY.toCompressedXContent(), Mapping.EMPTY.toCompressedXContent()));
                countDownListener.onResponse(null);
            }));
        }
    }

    private void updateSingleDataStream(ProjectId projectId, String dataStreamName, CompressedXContent mappingsOverrides, TimeValue masterNodeTimeout, TimeValue ackTimeout, boolean dryRun, ActionListener<UpdateDataStreamMappingsAction.DataStreamMappingsResponse> listener) {
        logger.debug("updating mappings for {}", (Object)dataStreamName);
        if (this.systemIndices.isSystemDataStream(dataStreamName)) {
            listener.onResponse((Object)new UpdateDataStreamMappingsAction.DataStreamMappingsResponse(dataStreamName, false, "Cannot update a system data stream", Mapping.EMPTY.toCompressedXContent(), Mapping.EMPTY.toCompressedXContent()));
            return;
        }
        this.metadataDataStreamsService.updateMappings(projectId, masterNodeTimeout, ackTimeout, dataStreamName, mappingsOverrides, dryRun, listener.delegateFailure((dataStreamMappingsResponseActionListener, dataStream) -> {
            if (dataStream != null) {
                try {
                    dataStreamMappingsResponseActionListener.onResponse((Object)new UpdateDataStreamMappingsAction.DataStreamMappingsResponse(dataStreamName, true, null, mappingsOverrides, dataStream.getEffectiveMappings(this.clusterService.state().metadata().getProject(projectId), this.indicesService)));
                }
                catch (IOException e) {
                    dataStreamMappingsResponseActionListener.onResponse((Object)new UpdateDataStreamMappingsAction.DataStreamMappingsResponse(dataStreamName, false, e.getMessage(), Mapping.EMPTY.toCompressedXContent(), Mapping.EMPTY.toCompressedXContent()));
                }
            } else {
                dataStreamMappingsResponseActionListener.onResponse((Object)new UpdateDataStreamMappingsAction.DataStreamMappingsResponse(dataStreamName, false, "Updating mappings not accepted for unknown reasons", Mapping.EMPTY.toCompressedXContent(), Mapping.EMPTY.toCompressedXContent()));
            }
        }));
    }

    protected ClusterBlockException checkBlock(UpdateDataStreamMappingsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

