/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.core.security.authz.AuthorizationServiceField;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.interceptor.RequestInterceptor;

abstract class FieldAndDocumentLevelSecurityRequestInterceptor
implements RequestInterceptor {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final Logger logger;

    FieldAndDocumentLevelSecurityRequestInterceptor(ThreadContext threadContext, XPackLicenseState licenseState) {
        this.threadContext = threadContext;
        this.licenseState = licenseState;
        this.logger = LogManager.getLogger(this.getClass());
    }

    @Override
    public SubscribableListener<Void> intercept(AuthorizationEngine.RequestInfo requestInfo, AuthorizationEngine authorizationEngine, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        boolean isDlsLicensed = SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState);
        boolean isFlsLicensed = SecurityField.FIELD_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState);
        TransportRequest transportRequest = requestInfo.getRequest();
        if (transportRequest instanceof IndicesRequest) {
            IndicesRequest indicesRequest = (IndicesRequest)transportRequest;
            if (!TransportActionProxy.isProxyAction((String)requestInfo.getAction()) && this.supports(indicesRequest) && (isDlsLicensed || isFlsLicensed)) {
                IndicesAccessControl indicesAccessControl = (IndicesAccessControl)AuthorizationServiceField.INDICES_PERMISSIONS_VALUE.get(this.threadContext);
                HashMap<String, IndicesAccessControl.IndexAccessControl> accessControlByIndex = new HashMap<String, IndicesAccessControl.IndexAccessControl>();
                for (String index : this.requestIndices(indicesRequest)) {
                    IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(index);
                    if (indexAccessControl == null || !indexAccessControl.getFieldPermissions().hasFieldLevelSecurity() && !indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions()) continue;
                    this.logger.trace("intercepted request for index [{}] with field level access controls [{}] document level access controls [{}]. disabling conflicting features", (Object)index, (Object)indexAccessControl.getFieldPermissions().hasFieldLevelSecurity(), (Object)indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions());
                    accessControlByIndex.put(index, indexAccessControl);
                }
                if (!accessControlByIndex.isEmpty()) {
                    SubscribableListener listener = new SubscribableListener();
                    this.disableFeatures(indicesRequest, accessControlByIndex, (ActionListener<Void>)listener);
                    return listener;
                }
            }
        }
        return SubscribableListener.nullSuccess();
    }

    abstract void disableFeatures(IndicesRequest var1, Map<String, IndicesAccessControl.IndexAccessControl> var2, ActionListener<Void> var3);

    String[] requestIndices(IndicesRequest indicesRequest) {
        return indicesRequest.indices();
    }

    abstract boolean supports(IndicesRequest var1);
}

