/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.OptionalLong;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;

public class ExponentialHistogramQuantile {
    public static double getQuantile(ExponentialHistogram histo, double quantile) {
        long posCount;
        long negCount;
        if (quantile < 0.0 || quantile > 1.0) {
            throw new IllegalArgumentException("quantile must be in range [0, 1]");
        }
        long zeroCount = histo.zeroBucket().count();
        long totalCount = zeroCount + (negCount = histo.negativeBuckets().valueCount()) + (posCount = histo.positiveBuckets().valueCount());
        if (totalCount == 0L) {
            return Double.NaN;
        }
        double exactRank = quantile * (double)(totalCount - 1L);
        long lowerRank = (long)Math.floor(exactRank);
        long upperRank = (long)Math.ceil(exactRank);
        double upperFactor = exactRank - (double)lowerRank;
        ValueAndPreviousValue values = ExponentialHistogramQuantile.getElementAtRank(histo, upperRank);
        values = values.clampTo(histo.min(), histo.max());
        double result = lowerRank == upperRank ? values.valueAtRank() : values.valueAtPreviousRank() * (1.0 - upperFactor) + values.valueAtRank() * upperFactor;
        return ExponentialHistogramQuantile.removeNegativeZero(result);
    }

    public static long estimateRank(ExponentialHistogram histo, double value, boolean inclusive) {
        if (Double.isNaN(histo.min()) || value < histo.min()) {
            return 0L;
        }
        if (value > histo.max()) {
            return histo.valueCount();
        }
        if (value >= 0.0) {
            long rank = histo.negativeBuckets().valueCount();
            if (value > 0.0 || inclusive) {
                rank += histo.zeroBucket().count();
            }
            return rank += ExponentialHistogramQuantile.estimateRank(histo.positiveBuckets().iterator(), value, inclusive, histo.max());
        }
        long numValuesGreater = ExponentialHistogramQuantile.estimateRank(histo.negativeBuckets().iterator(), -value, !inclusive, -histo.min());
        return histo.negativeBuckets().valueCount() - numValuesGreater;
    }

    private static long estimateRank(BucketIterator buckets, double value, boolean inclusive, double maxValue) {
        long rank = 0L;
        while (buckets.hasNext()) {
            double bucketMidpoint = ExponentialScaleUtils.getPointOfLeastRelativeError(buckets.peekIndex(), buckets.scale());
            if (!((bucketMidpoint = Math.min(bucketMidpoint, maxValue)) < value) && (!inclusive || bucketMidpoint != value)) break;
            rank += buckets.peekCount();
            buckets.advance();
        }
        return rank;
    }

    private static double removeNegativeZero(double result) {
        return result == 0.0 ? 0.0 : result;
    }

    private static ValueAndPreviousValue getElementAtRank(ExponentialHistogram histo, long rank) {
        long negativeValuesCount = histo.negativeBuckets().valueCount();
        long zeroCount = histo.zeroBucket().count();
        if (rank < negativeValuesCount) {
            if (rank == 0L) {
                return new ValueAndPreviousValue(Double.NaN, -ExponentialHistogramQuantile.getLastBucketMidpoint(histo.negativeBuckets()));
            }
            return ExponentialHistogramQuantile.getBucketMidpointForRank(histo.negativeBuckets().iterator(), negativeValuesCount - rank).negateAndSwap();
        }
        if (rank < negativeValuesCount + zeroCount) {
            if (rank == negativeValuesCount) {
                return new ValueAndPreviousValue(-ExponentialHistogramQuantile.getFirstBucketMidpoint(histo.negativeBuckets()), 0.0);
            }
            return new ValueAndPreviousValue(0.0, 0.0);
        }
        ValueAndPreviousValue result = ExponentialHistogramQuantile.getBucketMidpointForRank(histo.positiveBuckets().iterator(), rank - negativeValuesCount - zeroCount);
        if (rank - 1L < negativeValuesCount) {
            return new ValueAndPreviousValue(-ExponentialHistogramQuantile.getFirstBucketMidpoint(histo.negativeBuckets()), result.valueAtRank);
        }
        if (rank - 1L < negativeValuesCount + zeroCount) {
            return new ValueAndPreviousValue(0.0, result.valueAtRank);
        }
        return result;
    }

    private static double getFirstBucketMidpoint(ExponentialHistogram.Buckets buckets) {
        CopyableBucketIterator iterator = buckets.iterator();
        if (iterator.hasNext()) {
            return ExponentialScaleUtils.getPointOfLeastRelativeError(iterator.peekIndex(), iterator.scale());
        }
        return Double.NaN;
    }

    private static double getLastBucketMidpoint(ExponentialHistogram.Buckets buckets) {
        OptionalLong highestIndex = buckets.maxBucketIndex();
        if (highestIndex.isPresent()) {
            return ExponentialScaleUtils.getPointOfLeastRelativeError(highestIndex.getAsLong(), buckets.iterator().scale());
        }
        return Double.NaN;
    }

    private static ValueAndPreviousValue getBucketMidpointForRank(BucketIterator buckets, long rank) {
        long prevIndex = Long.MIN_VALUE;
        long seenCount = 0L;
        while (buckets.hasNext()) {
            if (rank < (seenCount += buckets.peekCount())) {
                double center = ExponentialScaleUtils.getPointOfLeastRelativeError(buckets.peekIndex(), buckets.scale());
                double prevCenter = rank > 0L ? (rank - 1L >= seenCount - buckets.peekCount() ? center : ExponentialScaleUtils.getPointOfLeastRelativeError(prevIndex, buckets.scale())) : Double.NaN;
                return new ValueAndPreviousValue(prevCenter, center);
            }
            prevIndex = buckets.peekIndex();
            buckets.advance();
        }
        throw new IllegalStateException("The total number of elements in the buckets is less than the desired rank.");
    }

    private record ValueAndPreviousValue(double valueAtPreviousRank, double valueAtRank) {
        ValueAndPreviousValue negateAndSwap() {
            return new ValueAndPreviousValue(-this.valueAtRank, -this.valueAtPreviousRank);
        }

        ValueAndPreviousValue clampTo(double min, double max) {
            return new ValueAndPreviousValue(Math.clamp(this.valueAtPreviousRank, min, max), Math.clamp(this.valueAtRank, min, max));
        }
    }
}

