/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.TreeMap;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramUtils;
import org.elasticsearch.exponentialhistogram.FixedCapacityExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ReleasableExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

public class ExponentialHistogramBuilder
implements Releasable {
    private static final int DEFAULT_ESTIMATED_BUCKET_COUNT = 32;
    private final ExponentialHistogramCircuitBreaker breaker;
    private int scale;
    private ZeroBucket zeroBucket = ZeroBucket.minimalEmpty();
    private Double sum;
    private Double min;
    private Double max;
    private int estimatedBucketCount = 32;
    private FixedCapacityExponentialHistogram result;
    TreeMap<Long, Long> negativeBuckets;
    TreeMap<Long, Long> positiveBuckets;
    private boolean resultAlreadyReturned = false;

    ExponentialHistogramBuilder(int scale, ExponentialHistogramCircuitBreaker breaker) {
        this.breaker = breaker;
        this.scale = scale;
    }

    ExponentialHistogramBuilder(ExponentialHistogram toCopy, ExponentialHistogramCircuitBreaker breaker) {
        this(toCopy.scale(), breaker);
        this.zeroBucket(toCopy.zeroBucket());
        this.sum(toCopy.sum());
        this.min(toCopy.min());
        this.max(toCopy.max());
        this.estimatedBucketCount(toCopy.negativeBuckets().bucketCount() + toCopy.positiveBuckets().bucketCount());
        CopyableBucketIterator negBuckets = toCopy.negativeBuckets().iterator();
        while (negBuckets.hasNext()) {
            this.setNegativeBucket(negBuckets.peekIndex(), negBuckets.peekCount());
            negBuckets.advance();
        }
        CopyableBucketIterator posBuckets = toCopy.positiveBuckets().iterator();
        while (posBuckets.hasNext()) {
            this.setPositiveBucket(posBuckets.peekIndex(), posBuckets.peekCount());
            posBuckets.advance();
        }
    }

    public ExponentialHistogramBuilder estimatedBucketCount(int totalBuckets) {
        this.estimatedBucketCount = totalBuckets;
        return this;
    }

    public ExponentialHistogramBuilder scale(int scale) {
        this.scale = scale;
        return this;
    }

    public ExponentialHistogramBuilder zeroBucket(ZeroBucket zeroBucket) {
        this.zeroBucket = zeroBucket;
        return this;
    }

    public ExponentialHistogramBuilder sum(double sum) {
        this.sum = sum;
        return this;
    }

    public ExponentialHistogramBuilder min(double min) {
        this.min = min;
        return this;
    }

    public ExponentialHistogramBuilder max(double max) {
        this.max = max;
        return this;
    }

    public ExponentialHistogramBuilder setPositiveBucket(long index, long count) {
        this.setBucket(index, count, true);
        return this;
    }

    public ExponentialHistogramBuilder setNegativeBucket(long index, long count) {
        this.setBucket(index, count, false);
        return this;
    }

    private void setBucket(long index, long count, boolean isPositive) {
        if (count < 1L) {
            throw new IllegalArgumentException("Bucket count must be at least 1");
        }
        if (this.negativeBuckets == null && this.positiveBuckets == null) {
            if (this.result == null) {
                this.reallocateResultWithCapacity(this.estimatedBucketCount, false);
            }
            if (isPositive && !this.result.wasLastAddedBucketPositive() || isPositive == this.result.wasLastAddedBucketPositive() && index > this.result.getLastAddedBucketIndex()) {
                this.addBucketToResult(index, count, isPositive);
                return;
            }
        }
        this.initializeBucketTreeMapsIfNeeded();
        if (isPositive) {
            this.positiveBuckets.put(index, count);
        } else {
            this.negativeBuckets.put(index, count);
        }
    }

    private void initializeBucketTreeMapsIfNeeded() {
        if (this.negativeBuckets == null) {
            this.negativeBuckets = new TreeMap();
            this.positiveBuckets = new TreeMap();
            if (this.result != null) {
                CopyableBucketIterator it = this.result.negativeBuckets().iterator();
                while (it.hasNext()) {
                    this.negativeBuckets.put(it.peekIndex(), it.peekCount());
                    it.advance();
                }
                it = this.result.positiveBuckets().iterator();
                while (it.hasNext()) {
                    this.positiveBuckets.put(it.peekIndex(), it.peekCount());
                    it.advance();
                }
            }
        }
    }

    private void addBucketToResult(long index, long count, boolean isPositive) {
        if (this.resultAlreadyReturned) {
            this.reallocateResultWithCapacity(this.result.getCapacity(), true);
        }
        assert (!this.resultAlreadyReturned);
        boolean sufficientCapacity = this.result.tryAddBucket(index, count, isPositive);
        if (!sufficientCapacity) {
            int newCapacity = Math.max(this.result.getCapacity() * 2, 32);
            this.reallocateResultWithCapacity(newCapacity, true);
            boolean bucketAdded = this.result.tryAddBucket(index, count, isPositive);
            assert (bucketAdded) : "Output histogram should have enough capacity";
        }
    }

    private void reallocateResultWithCapacity(int newCapacity, boolean copyBucketsFromPreviousResult) {
        FixedCapacityExponentialHistogram newResult = FixedCapacityExponentialHistogram.create(newCapacity, this.breaker);
        if (copyBucketsFromPreviousResult && this.result != null) {
            boolean added;
            CopyableBucketIterator it = this.result.negativeBuckets().iterator();
            while (it.hasNext()) {
                added = newResult.tryAddBucket(it.peekIndex(), it.peekCount(), false);
                assert (added) : "Output histogram should have enough capacity";
                it.advance();
            }
            it = this.result.positiveBuckets().iterator();
            while (it.hasNext()) {
                added = newResult.tryAddBucket(it.peekIndex(), it.peekCount(), true);
                assert (added) : "Output histogram should have enough capacity";
                it.advance();
            }
        }
        if (this.result != null && !this.resultAlreadyReturned) {
            Releasables.close((Releasable)this.result);
        }
        this.resultAlreadyReturned = false;
        this.result = newResult;
    }

    public ReleasableExponentialHistogram build() {
        if (this.resultAlreadyReturned) {
            this.reallocateResultWithCapacity(this.result.getCapacity(), true);
        }
        assert (!this.resultAlreadyReturned);
        if (this.negativeBuckets != null) {
            this.reallocateResultWithCapacity(this.negativeBuckets.size() + this.positiveBuckets.size(), false);
            this.result.resetBuckets(this.scale);
            this.negativeBuckets.forEach((index, count) -> this.result.tryAddBucket((long)index, (long)count, false));
            this.positiveBuckets.forEach((index, count) -> this.result.tryAddBucket((long)index, (long)count, true));
        } else {
            if (this.result == null) {
                this.reallocateResultWithCapacity(0, false);
            }
            this.result.setScale(this.scale);
        }
        this.result.setZeroBucket(this.zeroBucket);
        double sumVal = this.sum != null ? this.sum : ExponentialHistogramUtils.estimateSum(this.result.negativeBuckets().iterator(), this.result.positiveBuckets().iterator());
        double minVal = this.min != null ? this.min.doubleValue() : ExponentialHistogramUtils.estimateMin(this.zeroBucket, this.result.negativeBuckets(), this.result.positiveBuckets()).orElse(Double.NaN);
        double maxVal = this.max != null ? this.max.doubleValue() : ExponentialHistogramUtils.estimateMax(this.zeroBucket, this.result.negativeBuckets(), this.result.positiveBuckets()).orElse(Double.NaN);
        this.result.setMin(minVal);
        this.result.setMax(maxVal);
        this.result.setSum(sumVal);
        this.resultAlreadyReturned = true;
        return this.result;
    }

    public void close() {
        if (!this.resultAlreadyReturned) {
            Releasables.close((Releasable)this.result);
        }
    }
}

