/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.retriever;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RuleQueryRankDoc
extends RankDoc {
    public static final String NAME = "query_rule_rank_doc";
    public final List<String> rulesetIds;
    public final Map<String, Object> matchCriteria;

    public RuleQueryRankDoc(int doc, float score, int shardIndex) {
        this(doc, score, shardIndex, null, null);
    }

    public RuleQueryRankDoc(int doc, float score, int shardIndex, List<String> rulesetIds, Map<String, Object> matchCriteria) {
        super(doc, score, shardIndex);
        this.rulesetIds = rulesetIds;
        this.matchCriteria = matchCriteria;
    }

    public RuleQueryRankDoc(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            List inRulesetIds = in.readOptionalStringCollectionAsList();
            this.rulesetIds = inRulesetIds == null ? null : Collections.unmodifiableList(inRulesetIds);
            boolean matchCriteriaExists = in.readBoolean();
            this.matchCriteria = matchCriteriaExists ? in.readGenericMap() : null;
        } else {
            this.rulesetIds = in.readStringCollectionAsImmutableList();
            this.matchCriteria = in.readGenericMap();
        }
    }

    public Explanation explain(Explanation[] sources, String[] queryNames) {
        assert (this.rulesetIds != null && this.matchCriteria != null);
        return Explanation.match((Number)Float.valueOf(this.score), (String)("query rules evaluated rules from rulesets " + String.valueOf(this.rulesetIds) + " and match criteria " + String.valueOf(this.matchCriteria)), (Explanation[])sources);
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
            out.writeOptionalStringCollection(this.rulesetIds);
            out.writeBoolean(this.matchCriteria != null);
            if (this.matchCriteria != null) {
                out.writeGenericMap(this.matchCriteria);
            }
        } else {
            out.writeStringCollection(this.rulesetIds == null ? Collections.emptyList() : this.rulesetIds);
            out.writeGenericMap(this.matchCriteria == null ? Collections.emptyMap() : this.matchCriteria);
        }
    }

    public boolean doEquals(RankDoc rd) {
        RuleQueryRankDoc rqrd = (RuleQueryRankDoc)rd;
        return Objects.equals(this.rulesetIds, rqrd.rulesetIds) && Objects.equals(this.matchCriteria, rqrd.matchCriteria);
    }

    public int doHashCode() {
        return Objects.hash(this.rulesetIds, this.matchCriteria);
    }

    public String toString() {
        return "QueryRuleRankDoc{doc=" + this.doc + ", shardIndex=" + this.shardIndex + ", score=" + this.score + ", rulesetIds=" + String.valueOf(this.rulesetIds) + ", matchCriteria=" + String.valueOf(this.matchCriteria) + "}";
    }

    public String getWriteableName() {
        return NAME;
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.rulesetIds != null) {
            builder.array("rulesetIds", this.rulesetIds.toArray());
        }
        if (this.matchCriteria != null) {
            builder.startObject("matchCriteria");
            builder.mapContents(this.matchCriteria);
            builder.endObject();
        }
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_17_0;
    }
}

