/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.application.rules.QueryRule;
import org.elasticsearch.xpack.application.rules.QueryRuleset;

public class PutQueryRulesetAction {
    public static final String NAME = "cluster:admin/xpack/query_rules/put";
    public static final ActionType<Response> INSTANCE = new ActionType("cluster:admin/xpack/query_rules/put");

    private PutQueryRulesetAction() {
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        final DocWriteResponse.Result result;

        public Response(StreamInput in) throws IOException {
            this.result = DocWriteResponse.Result.readFrom((StreamInput)in);
        }

        public Response(DocWriteResponse.Result result) {
            this.result = result;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.result.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("result", this.result.getLowercase());
            builder.endObject();
            return builder;
        }

        public RestStatus status() {
            return switch (this.result) {
                case DocWriteResponse.Result.CREATED -> RestStatus.CREATED;
                case DocWriteResponse.Result.NOT_FOUND -> RestStatus.NOT_FOUND;
                default -> RestStatus.OK;
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return Objects.equals(this.result, that.result);
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements ToXContentObject {
        private final QueryRuleset queryRuleset;
        private static final ParseField QUERY_RULESET_FIELD = new ParseField("queryRuleset", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("put_query_rules_request", p -> new Request((QueryRuleset)p[0]));

        public Request(StreamInput in) throws IOException {
            super(in);
            this.queryRuleset = new QueryRuleset(in);
        }

        public Request(QueryRuleset queryRuleset) {
            this.queryRuleset = queryRuleset;
        }

        public Request(String rulesetId, BytesReference content, XContentType contentType) {
            this.queryRuleset = QueryRuleset.fromXContentBytes(rulesetId, content, contentType);
        }

        public ActionRequestValidationException validate() {
            List<QueryRule> rules;
            ActionRequestValidationException validationException = null;
            if (Strings.isNullOrEmpty((String)this.queryRuleset.id())) {
                validationException = ValidateActions.addValidationError((String)"ruleset_id cannot be null or empty", validationException);
            }
            if ((rules = this.queryRuleset.rules()) == null || rules.isEmpty()) {
                validationException = ValidateActions.addValidationError((String)"rules cannot be null or empty", (ActionRequestValidationException)validationException);
            } else {
                for (QueryRule rule : rules) {
                    if (rule.id() != null) continue;
                    validationException = ValidateActions.addValidationError((String)("rule_id cannot be null or empty. rule: [" + String.valueOf(rule) + "]"), (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.queryRuleset.writeTo(out);
        }

        public QueryRuleset queryRuleset() {
            return this.queryRuleset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.queryRuleset, request.queryRuleset);
        }

        public int hashCode() {
            return Objects.hash(this.queryRuleset);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return this.queryRuleset.toXContent(builder, params);
        }

        public static Request fromXContent(String id, XContentParser parser) throws IOException {
            return new Request(QueryRuleset.fromXContent(id, parser));
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> QueryRuleset.fromXContent(c, p), QUERY_RULESET_FIELD);
        }
    }
}

