/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestRefCountedChunkedToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.usage.SearchUsageHolder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.search.action.AsyncSearchResponse;
import org.elasticsearch.xpack.core.search.action.SubmitAsyncSearchAction;
import org.elasticsearch.xpack.core.search.action.SubmitAsyncSearchRequest;

@ServerlessScope(value=Scope.PUBLIC)
public final class RestSubmitAsyncSearchAction
extends BaseRestHandler {
    static final String TYPED_KEYS_PARAM = "typed_keys";
    static final Set<String> RESPONSE_PARAMS = Collections.singleton("typed_keys");
    private final SearchUsageHolder searchUsageHolder;
    private final Predicate<NodeFeature> clusterSupportsFeature;
    private final Settings settings;

    public RestSubmitAsyncSearchAction(SearchUsageHolder searchUsageHolder, Predicate<NodeFeature> clusterSupportsFeature) {
        this(searchUsageHolder, clusterSupportsFeature, null);
    }

    public RestSubmitAsyncSearchAction(SearchUsageHolder searchUsageHolder, Predicate<NodeFeature> clusterSupportsFeature, Settings settings) {
        this.searchUsageHolder = searchUsageHolder;
        this.clusterSupportsFeature = clusterSupportsFeature;
        this.settings = settings;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_async_search"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_async_search"));
    }

    public String getName() {
        return "async_search_submit_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (client.threadPool() != null && client.threadPool().getThreadContext() != null) {
            client.threadPool().getThreadContext().setErrorTraceTransportHeader(request);
        }
        SubmitAsyncSearchRequest submit = new SubmitAsyncSearchRequest(new String[0]);
        if (this.settings != null && this.settings.getAsBoolean("serverless.cross_project.enabled", Boolean.valueOf(false)).booleanValue()) {
            request.param("project_routing");
        }
        IntConsumer setSize = size -> submit.getSearchRequest().source().size(size);
        request.withContentOrSourceParamParserOrNull(parser -> RestSearchAction.parseSearchRequest((SearchRequest)submit.getSearchRequest(), (RestRequest)request, (XContentParser)parser, this.clusterSupportsFeature, (IntConsumer)setSize, (SearchUsageHolder)this.searchUsageHolder));
        if (request.hasParam("wait_for_completion_timeout")) {
            submit.setWaitForCompletionTimeout(request.paramAsTime("wait_for_completion_timeout", submit.getWaitForCompletionTimeout()));
        }
        if (request.hasParam("keep_alive")) {
            submit.setKeepAlive(request.paramAsTime("keep_alive", submit.getKeepAlive()));
        }
        if (request.hasParam("keep_on_completion")) {
            submit.setKeepOnCompletion(request.paramAsBoolean("keep_on_completion", submit.isKeepOnCompletion()));
        }
        return channel -> {
            RestCancellableNodeClient cancelClient = new RestCancellableNodeClient(client, request.getHttpChannel());
            cancelClient.execute((ActionType)SubmitAsyncSearchAction.INSTANCE, (ActionRequest)submit, (ActionListener)new RestRefCountedChunkedToXContentListener<AsyncSearchResponse>(this, channel){

                protected RestStatus getRestStatus(AsyncSearchResponse asyncSearchResponse) {
                    return asyncSearchResponse.status();
                }
            });
        };
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

