/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractPageMappingToIteratorOperator
implements Operator {
    private ReleasableIterator<Page> next;
    private boolean finished = false;
    private long processNanos;
    private int pagesReceived;
    private int pagesEmitted;
    private long rowsReceived;
    private long rowsEmitted;

    protected abstract ReleasableIterator<Page> receive(Page var1);

    public static ReleasableIterator<Page> appendBlockArrays(Page page, ReleasableIterator<Block[]> toAdd) {
        return new AppendBlocksIterator(page, toAdd);
    }

    public static ReleasableIterator<Page> appendBlocks(Page page, final ReleasableIterator<? extends Block> toAdd) {
        return AbstractPageMappingToIteratorOperator.appendBlockArrays(page, new ReleasableIterator<Block[]>(){

            public boolean hasNext() {
                return toAdd.hasNext();
            }

            public Block[] next() {
                return new Block[]{(Block)toAdd.next()};
            }

            public void close() {
                toAdd.close();
            }
        });
    }

    public abstract String toString();

    @Override
    public final boolean needsInput() {
        return !this.finished && (this.next == null || !this.next.hasNext());
    }

    @Override
    public final void addInput(Page page) {
        if (this.next != null) {
            assert (!this.next.hasNext()) : "has pending input page";
            this.next.close();
            this.next = null;
        }
        if (page.getPositionCount() == 0) {
            return;
        }
        try {
            this.next = new RuntimeTrackingIterator(this.receive(page));
            ++this.pagesReceived;
            this.rowsReceived += (long)page.getPositionCount();
        }
        finally {
            if (this.next == null) {
                page.releaseBlocks();
            }
        }
    }

    @Override
    public final void finish() {
        this.finished = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finished && (this.next == null || !this.next.hasNext());
    }

    @Override
    public final Page getOutput() {
        if (this.next == null || !this.next.hasNext()) {
            return null;
        }
        Page ret = (Page)this.next.next();
        ++this.pagesEmitted;
        this.rowsEmitted += (long)ret.getPositionCount();
        return ret;
    }

    @Override
    public final Status status() {
        return this.status(this.processNanos, this.pagesReceived, this.pagesEmitted, this.rowsReceived, this.rowsEmitted);
    }

    protected Status status(long processNanos, int pagesReceived, int pagesEmitted, long rowsReceived, long rowsEmitted) {
        return new Status(processNanos, pagesReceived, pagesEmitted, rowsReceived, rowsEmitted);
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException(this.next);
    }

    private static class AppendBlocksIterator
    implements ReleasableIterator<Page> {
        private final Page page;
        private final ReleasableIterator<Block[]> next;
        private boolean closed = false;
        private int positionOffset;

        protected AppendBlocksIterator(Page page, ReleasableIterator<Block[]> next) {
            this.page = page;
            this.next = next;
        }

        public final boolean hasNext() {
            if (this.next.hasNext()) {
                assert (this.positionOffset < this.page.getPositionCount());
                return true;
            }
            assert (this.positionOffset == this.page.getPositionCount());
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final Page next() {
            Block[] read = (Block[])this.next.next();
            int start = this.positionOffset;
            this.positionOffset += read[0].getPositionCount();
            if (start == 0 && read[0].getPositionCount() == this.page.getPositionCount()) {
                for (int b = 0; b < this.page.getBlockCount(); ++b) {
                    this.page.getBlock(b).incRef();
                }
                Page result = this.page.appendBlocks(read);
                this.close();
                return result;
            }
            Object[] newBlocks = new Block[this.page.getBlockCount() + read.length];
            System.arraycopy(read, 0, newBlocks, this.page.getBlockCount(), read.length);
            try {
                int[] positions = IntStream.range(start, this.positionOffset).toArray();
                for (int b = 0; b < this.page.getBlockCount(); ++b) {
                    newBlocks[b] = this.page.getBlock(b).filter(positions);
                }
                Page result = new Page((Block[])newBlocks);
                Arrays.fill(newBlocks, null);
                Page page = result;
                return page;
            }
            finally {
                Releasables.closeExpectNoException((Releasable[])newBlocks);
            }
        }

        public void close() {
            if (!this.closed) {
                this.closed = true;
                Releasable[] releasableArray = new Releasable[2];
                releasableArray[0] = this.page::releaseBlocks;
                releasableArray[1] = this.next;
                Releasables.closeExpectNoException((Releasable[])releasableArray);
            }
        }
    }

    private class RuntimeTrackingIterator
    implements ReleasableIterator<Page> {
        private final ReleasableIterator<Page> next;

        private RuntimeTrackingIterator(ReleasableIterator<Page> next) {
            this.next = next;
        }

        public boolean hasNext() {
            return this.next.hasNext();
        }

        public Page next() {
            long start = System.nanoTime();
            Page out = (Page)this.next.next();
            AbstractPageMappingToIteratorOperator.this.processNanos += System.nanoTime() - start;
            return out;
        }

        public void close() {
            this.next.close();
        }
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "page_mapping_to_iterator", Status::new);
        private final long processNanos;
        private final int pagesReceived;
        private final int pagesEmitted;
        private final long rowsReceived;
        private final long rowsEmitted;

        public Status(long processNanos, int pagesProcessed, int pagesEmitted, long rowsReceived, long rowsEmitted) {
            this.processNanos = processNanos;
            this.pagesReceived = pagesProcessed;
            this.pagesEmitted = pagesEmitted;
            this.rowsReceived = rowsReceived;
            this.rowsEmitted = rowsEmitted;
        }

        public Status(StreamInput in) throws IOException {
            this.processNanos = in.readVLong();
            this.pagesReceived = in.readVInt();
            this.pagesEmitted = in.readVInt();
            if (in.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                this.rowsReceived = in.readVLong();
                this.rowsEmitted = in.readVLong();
            } else {
                this.rowsReceived = 0L;
                this.rowsEmitted = 0L;
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.processNanos);
            out.writeVInt(this.pagesReceived);
            out.writeVInt(this.pagesEmitted);
            if (out.getTransportVersion().supports(TransportVersions.V_8_18_0)) {
                out.writeVLong(this.rowsReceived);
                out.writeVLong(this.rowsEmitted);
            }
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int pagesReceived() {
            return this.pagesReceived;
        }

        public int pagesEmitted() {
            return this.pagesEmitted;
        }

        public long rowsReceived() {
            return this.rowsReceived;
        }

        public long rowsEmitted() {
            return this.rowsEmitted;
        }

        public long processNanos() {
            return this.processNanos;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.innerToXContent(builder);
            return builder.endObject();
        }

        protected final XContentBuilder innerToXContent(XContentBuilder builder) throws IOException {
            builder.field("process_nanos", this.processNanos);
            if (builder.humanReadable()) {
                builder.field("process_time", (Object)TimeValue.timeValueNanos((long)this.processNanos));
            }
            return builder.field("pages_received", this.pagesReceived).field("pages_emitted", this.pagesEmitted).field("rows_received", this.rowsReceived).field("rows_emitted", this.rowsEmitted);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.processNanos == status.processNanos && this.pagesReceived == status.pagesReceived && this.pagesEmitted == status.pagesEmitted && this.rowsReceived == status.rowsReceived && this.rowsEmitted == status.rowsEmitted;
        }

        public int hashCode() {
            return Objects.hash(this.processNanos, this.pagesReceived, this.pagesEmitted, this.rowsReceived, this.rowsEmitted);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_15_0;
        }
    }
}

