/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.lucene.IndexedByShardId;

public class IndexedByShardIdFromSingleton<T>
implements IndexedByShardId<T> {
    private final T value;
    private final int shardId;

    public IndexedByShardIdFromSingleton(T value) {
        this(value, 0);
    }

    public IndexedByShardIdFromSingleton(T value, int shardId) {
        this.value = value;
        this.shardId = shardId;
    }

    @Override
    public T get(int shardId) {
        if (shardId != this.shardId) {
            throw new IndexOutOfBoundsException("shardId should be 0 for a singleton, got: " + shardId);
        }
        return this.value;
    }

    @Override
    public Collection<? extends T> collection() {
        return List.of(this.value);
    }

    @Override
    public <S> IndexedByShardId<S> map(Function<T, S> mapper) {
        return new IndexedByShardIdFromSingleton<S>(mapper.apply(this.value), this.shardId);
    }
}

