/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ConstantFloatVector;
import org.elasticsearch.compute.data.ConstantNullVector;
import org.elasticsearch.compute.data.FloatArrayVector;
import org.elasticsearch.compute.data.FloatBigArrayVector;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVectorBuilder;
import org.elasticsearch.compute.data.FloatVectorFixedBuilder;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.core.ReleasableIterator;

public sealed interface FloatVector
extends Vector
permits ConstantFloatVector, FloatArrayVector, FloatBigArrayVector, ConstantNullVector {
    public float getFloat(int var1);

    @Override
    public FloatBlock asBlock();

    @Override
    public FloatVector filter(int ... var1);

    @Override
    public FloatBlock keepMask(BooleanVector var1);

    @Override
    default public FloatVector deepCopy(BlockFactory blockFactory) {
        try (FloatBlock.Builder builder = blockFactory.newFloatBlockBuilder(this.getPositionCount());){
            builder.copyFrom(this.asBlock(), 0, this.getPositionCount());
            builder.mvOrdering(Block.MvOrdering.DEDUPLICATED_AND_SORTED_ASCENDING);
            FloatVector floatVector = builder.build().asVector();
            return floatVector;
        }
    }

    public ReleasableIterator<? extends FloatBlock> lookup(IntBlock var1, ByteSizeValue var2);

    public boolean equals(Object var1);

    public int hashCode();

    public static boolean equals(FloatVector vector1, FloatVector vector2) {
        int positions = vector1.getPositionCount();
        if (positions != vector2.getPositionCount()) {
            return false;
        }
        for (int pos = 0; pos < positions; ++pos) {
            if (vector1.getFloat(pos) == vector2.getFloat(pos)) continue;
            return false;
        }
        return true;
    }

    public static int hash(FloatVector vector) {
        int len = vector.getPositionCount();
        int result = 1;
        for (int pos = 0; pos < len; ++pos) {
            result = 31 * result + Float.floatToIntBits(vector.getFloat(pos));
        }
        return result;
    }

    public static FloatVector readFrom(BlockFactory blockFactory, StreamInput in) throws IOException {
        int positions = in.readVInt();
        byte serializationType = in.readByte();
        return switch (serializationType) {
            case 0 -> FloatVector.readValues(positions, in, blockFactory);
            case 1 -> blockFactory.newConstantFloatVector(in.readFloat(), positions);
            case 2 -> FloatArrayVector.readArrayVector(positions, in, blockFactory);
            case 3 -> FloatBigArrayVector.readArrayVector(positions, in, blockFactory);
            default -> {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError((Object)("invalid vector serialization type [" + serializationType + "]"));
                }
                throw new IllegalStateException("invalid vector serialization type [" + serializationType + "]");
            }
        };
    }

    default public void writeTo(StreamOutput out) throws IOException {
        int positions = this.getPositionCount();
        TransportVersion version = out.getTransportVersion();
        out.writeVInt(positions);
        if (this.isConstant() && positions > 0) {
            out.writeByte((byte)1);
            out.writeFloat(this.getFloat(0));
        } else {
            FloatVector floatVector = this;
            if (floatVector instanceof FloatArrayVector) {
                FloatArrayVector v = (FloatArrayVector)floatVector;
                out.writeByte((byte)2);
                v.writeArrayVector(positions, out);
            } else {
                floatVector = this;
                if (floatVector instanceof FloatBigArrayVector) {
                    FloatBigArrayVector v = (FloatBigArrayVector)floatVector;
                    out.writeByte((byte)3);
                    v.writeArrayVector(positions, out);
                } else {
                    out.writeByte((byte)0);
                    FloatVector.writeValues(this, positions, out);
                }
            }
        }
    }

    private static FloatVector readValues(int positions, StreamInput in, BlockFactory blockFactory) throws IOException {
        try (FixedBuilder builder = blockFactory.newFloatVectorFixedBuilder(positions);){
            for (int i = 0; i < positions; ++i) {
                builder.appendFloat(i, in.readFloat());
            }
            FloatVector floatVector = builder.build();
            return floatVector;
        }
    }

    private static void writeValues(FloatVector v, int positions, StreamOutput out) throws IOException {
        for (int i = 0; i < positions; ++i) {
            out.writeFloat(v.getFloat(i));
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static sealed interface FixedBuilder
    extends Builder
    permits FloatVectorFixedBuilder {
        @Override
        public FixedBuilder appendFloat(float var1);

        public FixedBuilder appendFloat(int var1, float var2);
    }

    public static sealed interface Builder
    extends Vector.Builder
    permits FloatVectorBuilder, FixedBuilder {
        public Builder appendFloat(float var1);

        @Override
        public FloatVector build();
    }
}

