/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.CompositeBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class ToPartialAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("partial", ElementType.COMPOSITE, "partial_agg"));
    private final AggregatorFunction delegate;
    private final List<Integer> channels;

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    public ToPartialAggregatorFunction(AggregatorFunction delegate, List<Integer> channels) {
        this.delegate = delegate;
        this.channels = channels;
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        this.delegate.addRawInput(page, mask);
    }

    @Override
    public void addIntermediateInput(Page page) {
        CompositeBlock inputBlock = (CompositeBlock)page.getBlock(this.channels.get(0));
        this.delegate.addIntermediateInput(inputBlock.asPage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        Releasable[] partialBlocks = new Block[this.delegate.intermediateBlockCount()];
        boolean success = false;
        try {
            this.delegate.evaluateIntermediate((Block[])partialBlocks, 0, driverContext);
            blocks[offset] = new CompositeBlock((Block[])partialBlocks);
            success = true;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable[])partialBlocks);
            }
        }
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        this.evaluateIntermediate(blocks, offset, driverContext);
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    public void close() {
        Releasables.close((Releasable)this.delegate);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[channels=" + String.valueOf(this.channels) + ",delegate=" + String.valueOf(this.delegate) + "]";
    }
}

