/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class DimensionValuesByteRefGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("values", ElementType.BYTES_REF));
    private final BytesRefBlock.Builder builder;
    private final int channel;
    private final DriverContext driverContext;
    private int maxGroupId = -1;

    public DimensionValuesByteRefGroupingAggregatorFunction(List<Integer> channels, DriverContext driverContext) {
        this.channel = channels.getFirst();
        this.driverContext = driverContext;
        this.builder = driverContext.blockFactory().newBytesRefBlockBuilder(4096);
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final BytesRefBlock valuesBlock = (BytesRefBlock)page.getBlock(0);
        if (valuesBlock.areAllValuesNull()) {
            return new GroupingAggregatorFunction.AddInput(this){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                DimensionValuesByteRefGroupingAggregatorFunction.this.addInputValuesBlock(positionOffset, groupIds, valuesBlock);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                DimensionValuesByteRefGroupingAggregatorFunction.this.addInputValuesBlock(positionOffset, groupIds, valuesBlock);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                BytesRefVector valuesVector = valuesBlock.asVector();
                if (valuesVector != null) {
                    DimensionValuesByteRefGroupingAggregatorFunction.this.addInputValuesVector(positionOffset, groupIds, valuesVector);
                } else {
                    DimensionValuesByteRefGroupingAggregatorFunction.this.addInputValuesBlock(positionOffset, groupIds, valuesBlock);
                }
            }

            public void close() {
            }
        };
    }

    private void addInputValuesBlock(int positionOffset, IntBlock groups, BytesRefBlock valueBlock) {
        BytesRef scratch = new BytesRef();
        int positionCount = groups.getPositionCount();
        for (int p = 0; p < positionCount; ++p) {
            if (groups.isNull(p)) continue;
            int valuePosition = p + positionOffset;
            int groupStart = groups.getFirstValueIndex(p);
            int groupEnd = groupStart + groups.getValueCount(p);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                if (this.maxGroupId >= groupId) continue;
                this.fillNullsUpTo(groupId);
                this.builder.copyFrom(valueBlock, valuePosition, scratch);
                this.maxGroupId = groupId;
            }
        }
    }

    private void addInputValuesBlock(int positionOffset, IntVector groups, BytesRefBlock valueBlock) {
        BytesRef scratch = new BytesRef();
        int positionCount = groups.getPositionCount();
        if (groups.isConstant()) {
            int groupId = groups.getInt(0);
            if (groupId > this.maxGroupId) {
                this.fillNullsUpTo(groupId);
                this.builder.copyFrom(valueBlock, positionOffset, scratch);
                this.maxGroupId = groupId;
            }
        } else {
            for (int p = 0; p < positionCount; ++p) {
                int groupId = groups.getInt(p);
                if (groupId <= this.maxGroupId) continue;
                this.fillNullsUpTo(groupId);
                this.builder.copyFrom(valueBlock, positionOffset + p, scratch);
                this.maxGroupId = groupId;
            }
        }
    }

    private void addInputValuesVector(int positionOffset, IntVector groups, BytesRefVector valueVector) {
        BytesRef scratch = new BytesRef();
        int positionCount = groups.getPositionCount();
        if (groups.isConstant()) {
            int groupId = groups.getInt(0);
            if (groupId > this.maxGroupId) {
                this.fillNullsUpTo(groupId);
                this.builder.appendBytesRef(valueVector.getBytesRef(positionOffset, scratch));
                this.maxGroupId = groupId;
            }
        } else {
            for (int p = 0; p < positionCount; ++p) {
                int groupId = groups.getInt(p);
                if (groupId <= this.maxGroupId) continue;
                this.fillNullsUpTo(groupId);
                this.builder.appendBytesRef(valueVector.getBytesRef(positionOffset + p, scratch));
                this.maxGroupId = groupId;
            }
        }
    }

    private void fillNullsUpTo(int groupId) {
        for (int i = this.maxGroupId + 1; i < groupId; ++i) {
            this.builder.appendNull();
        }
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        BytesRefBlock valuesBlock = (BytesRefBlock)page.getBlock(this.channel);
        if (valuesBlock.areAllValuesNull()) {
            return;
        }
        this.addInputValuesBlock(positionOffset, groups, valuesBlock);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        BytesRefBlock valuesBlock = (BytesRefBlock)page.getBlock(this.channel);
        if (valuesBlock.areAllValuesNull()) {
            return;
        }
        this.addInputValuesBlock(positionOffset, groups, valuesBlock);
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        BytesRefBlock valuesBlock = (BytesRefBlock)page.getBlock(this.channel);
        if (valuesBlock.areAllValuesNull()) {
            return;
        }
        BytesRefVector valuesVector = valuesBlock.asVector();
        if (valuesVector != null) {
            this.addInputValuesVector(positionOffset, groups, valuesVector);
        } else {
            this.addInputValuesBlock(positionOffset, groups, valuesBlock);
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        boolean allSelected;
        int positionCount = selected.getPositionCount();
        boolean bl = allSelected = positionCount == this.maxGroupId + 1;
        if (allSelected) {
            for (int i = 0; i < selected.getPositionCount(); ++i) {
                if (selected.getInt(i) != i) continue;
                allSelected = false;
                break;
            }
        }
        if (allSelected) {
            blocks[offset] = this.builder.build();
            return;
        }
        BytesRef scratch = new BytesRef();
        try (BytesRefBlock block = this.builder.build();
             BytesRefBlock.Builder outputBuilder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int groupId = selected.getInt(p);
                if (groupId <= this.maxGroupId) {
                    outputBuilder.copyFrom(block, groupId, scratch);
                    continue;
                }
                outputBuilder.appendNull();
            }
            blocks[offset] = outputBuilder.build();
        }
    }

    public void close() {
        this.builder.close();
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext evalContext) {
        this.evaluateIntermediate(blocks, offset, selected);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channel);
        sb.append("]");
        return sb.toString();
    }

    public static final class FunctionSupplier
    implements AggregatorFunctionSupplier {
        @Override
        public List<IntermediateStateDesc> nonGroupingIntermediateStateDesc() {
            throw new UnsupportedOperationException("non-grouping aggregator is not supported");
        }

        @Override
        public List<IntermediateStateDesc> groupingIntermediateStateDesc() {
            return INTERMEDIATE_STATE_DESC;
        }

        @Override
        public AggregatorFunction aggregator(DriverContext driverContext, List<Integer> channels) {
            throw new UnsupportedOperationException("non-grouping aggregator is not supported");
        }

        @Override
        public DimensionValuesByteRefGroupingAggregatorFunction groupingAggregator(DriverContext driverContext, List<Integer> channels) {
            return new DimensionValuesByteRefGroupingAggregatorFunction(channels, driverContext);
        }

        @Override
        public String describe() {
            return "dimensions of bytes";
        }
    }
}

