/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.CountDistinctBooleanAggregator;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class CountDistinctBooleanAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("fbit", ElementType.BOOLEAN), new IntermediateStateDesc("tbit", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final CountDistinctBooleanAggregator.SingleState state;
    private final List<Integer> channels;

    public CountDistinctBooleanAggregatorFunction(DriverContext driverContext, List<Integer> channels, CountDistinctBooleanAggregator.SingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static CountDistinctBooleanAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new CountDistinctBooleanAggregatorFunction(driverContext, channels, CountDistinctBooleanAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        BooleanBlock vBlock = (BooleanBlock)page.getBlock(this.channels.get(0));
        BooleanVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock, mask);
            return;
        }
        this.addRawVector(vVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        BooleanBlock vBlock = (BooleanBlock)page.getBlock(this.channels.get(0));
        BooleanVector vVector = vBlock.asVector();
        if (vVector == null) {
            this.addRawBlock(vBlock);
            return;
        }
        this.addRawVector(vVector);
    }

    private void addRawVector(BooleanVector vVector) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            boolean vValue = vVector.getBoolean(valuesPosition);
            CountDistinctBooleanAggregator.combine(this.state, vValue);
        }
    }

    private void addRawVector(BooleanVector vVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < vVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            boolean vValue = vVector.getBoolean(valuesPosition);
            CountDistinctBooleanAggregator.combine(this.state, vValue);
        }
    }

    private void addRawBlock(BooleanBlock vBlock) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int vValueCount = vBlock.getValueCount(p);
            if (vValueCount == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                boolean vValue = vBlock.getBoolean(vOffset);
                CountDistinctBooleanAggregator.combine(this.state, vValue);
            }
        }
    }

    private void addRawBlock(BooleanBlock vBlock, BooleanVector mask) {
        for (int p = 0; p < vBlock.getPositionCount(); ++p) {
            int vValueCount;
            if (!mask.getBoolean(p) || (vValueCount = vBlock.getValueCount(p)) == 0) continue;
            int vStart = vBlock.getFirstValueIndex(p);
            int vEnd = vStart + vValueCount;
            for (int vOffset = vStart; vOffset < vEnd; ++vOffset) {
                boolean vValue = vBlock.getBoolean(vOffset);
                CountDistinctBooleanAggregator.combine(this.state, vValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + CountDistinctBooleanAggregatorFunction.intermediateStateDesc().size());
        Object fbitUncast = page.getBlock(this.channels.get(0));
        if (fbitUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector fbit = ((BooleanBlock)fbitUncast).asVector();
        assert (fbit.getPositionCount() == 1);
        Object tbitUncast = page.getBlock(this.channels.get(1));
        if (tbitUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector tbit = ((BooleanBlock)tbitUncast).asVector();
        assert (tbit.getPositionCount() == 1);
        CountDistinctBooleanAggregator.combineIntermediate(this.state, fbit.getBoolean(0), tbit.getBoolean(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = CountDistinctBooleanAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

