/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.normalize;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.AbstractPipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.BucketMetricsParser;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.analytics.normalize.NormalizePipelineAggregator;
import org.elasticsearch.xpack.analytics.normalize.NormalizePipelineMethods;

public class NormalizePipelineAggregationBuilder
extends AbstractPipelineAggregationBuilder<NormalizePipelineAggregationBuilder> {
    public static final String NAME = "normalize";
    static final ParseField METHOD_FIELD = new ParseField("method", new String[0]);
    public static final ConstructingObjectParser<NormalizePipelineAggregationBuilder, String> PARSER = new ConstructingObjectParser("normalize", false, (args, name) -> new NormalizePipelineAggregationBuilder((String)name, (String)args[0], (String)args[1], (List)args[2]));
    static final Map<String, Function<double[], DoubleUnaryOperator>> NAME_MAP;
    private final String format;
    private final String method;

    static String validateMethodName(String name) {
        if (NAME_MAP.containsKey(name)) {
            return name;
        }
        throw new IllegalArgumentException("invalid method [" + name + "]");
    }

    public NormalizePipelineAggregationBuilder(String name, String format, String method, List<String> bucketsPath) {
        super(name, NAME, bucketsPath.toArray(new String[0]));
        this.format = format;
        this.method = NormalizePipelineAggregationBuilder.validateMethodName(method);
    }

    public NormalizePipelineAggregationBuilder(StreamInput in) throws IOException {
        super(in, NAME);
        this.format = in.readOptionalString();
        this.method = in.readString();
    }

    protected final void doWriteTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.format);
        out.writeString(this.method);
    }

    public String format() {
        return this.format;
    }

    protected DocValueFormat formatter() {
        if (this.format != null) {
            return new DocValueFormat.Decimal(this.format);
        }
        return DocValueFormat.RAW;
    }

    protected PipelineAggregator createInternal(Map<String, Object> metadata) {
        return new NormalizePipelineAggregator(this.name, this.bucketsPaths, this.formatter(), NAME_MAP.get(this.method), metadata);
    }

    protected void validate(PipelineAggregationBuilder.ValidationContext context) {
        if (this.bucketsPaths.length != 1) {
            context.addBucketPathValidationError("must contain a single entry for aggregation [" + this.name + "]");
        }
        context.validateHasParent(NAME, this.name);
    }

    protected final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.format != null) {
            builder.field(BucketMetricsParser.FORMAT.getPreferredName(), this.format);
        }
        builder.field(METHOD_FIELD.getPreferredName(), this.method);
        return builder;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.format, this.method);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        NormalizePipelineAggregationBuilder other = (NormalizePipelineAggregationBuilder)((Object)obj);
        return Objects.equals(this.format, other.format) && Objects.equals(this.method, other.method);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PipelineAggregator.Parser.FORMAT);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), METHOD_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), BUCKETS_PATH_FIELD);
        NAME_MAP = Map.of("rescale_0_1", NormalizePipelineMethods.RescaleZeroToOne::new, "rescale_0_100", NormalizePipelineMethods.RescaleZeroToOneHundred::new, "mean", NormalizePipelineMethods.Mean::new, "z-score", NormalizePipelineMethods.ZScore::new, "percent_of_sum", NormalizePipelineMethods.Percent::new, "softmax", NormalizePipelineMethods.Softmax::new);
    }
}

