/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.analytics.mapper.IndexWithCount;

public class ExponentialHistogramParser {
    private static final ParseField SCALE_FIELD = new ParseField("scale", new String[0]);
    private static final ParseField SUM_FIELD = new ParseField("sum", new String[0]);
    private static final ParseField MIN_FIELD = new ParseField("min", new String[0]);
    private static final ParseField MAX_FIELD = new ParseField("max", new String[0]);
    private static final ParseField ZERO_FIELD = new ParseField("zero", new String[0]);
    private static final ParseField ZERO_COUNT_FIELD = new ParseField("count", new String[0]);
    private static final ParseField ZERO_THRESHOLD_FIELD = new ParseField("threshold", new String[0]);
    private static final ParseField POSITIVE_FIELD = new ParseField("positive", new String[0]);
    private static final ParseField NEGATIVE_FIELD = new ParseField("negative", new String[0]);
    private static final ParseField BUCKET_INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField BUCKET_COUNTS_FIELD = new ParseField("counts", new String[0]);
    public static final FeatureFlag EXPONENTIAL_HISTOGRAM_FEATURE = new FeatureFlag("exponential_histogram");

    public static ParsedExponentialHistogram parse(String mappedFieldName, XContentParser parser) throws IOException {
        Double sum = null;
        Double min = null;
        Double max = null;
        Integer scale = null;
        ParsedZeroBucket zeroBucket = ParsedZeroBucket.DEFAULT;
        List<IndexWithCount> negativeBuckets = Collections.emptyList();
        List<IndexWithCount> positiveBuckets = Collections.emptyList();
        XContentParser.Token token = parser.currentToken();
        while (token != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            String fieldName = parser.currentName();
            if (fieldName.equals(SCALE_FIELD.getPreferredName())) {
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                scale = parser.intValue();
                if (scale > 38 || scale < -11) {
                    throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], scale field must be in range [-11, 38] but got " + scale);
                }
            } else if (fieldName.equals(SUM_FIELD.getPreferredName())) {
                sum = ExponentialHistogramParser.parseDoubleAllowingInfinity(mappedFieldName, parser);
            } else if (fieldName.equals(MIN_FIELD.getPreferredName())) {
                min = ExponentialHistogramParser.parseDoubleAllowingInfinity(mappedFieldName, parser);
            } else if (fieldName.equals(MAX_FIELD.getPreferredName())) {
                max = ExponentialHistogramParser.parseDoubleAllowingInfinity(mappedFieldName, parser);
            } else if (fieldName.equals(ZERO_FIELD.getPreferredName())) {
                zeroBucket = ExponentialHistogramParser.parseZeroBucket(mappedFieldName, parser);
            } else if (fieldName.equals(POSITIVE_FIELD.getPreferredName())) {
                positiveBuckets = ExponentialHistogramParser.readAndValidateBuckets(mappedFieldName, POSITIVE_FIELD.getPreferredName(), parser);
            } else if (fieldName.equals(NEGATIVE_FIELD.getPreferredName())) {
                negativeBuckets = ExponentialHistogramParser.readAndValidateBuckets(mappedFieldName, NEGATIVE_FIELD.getPreferredName(), parser);
            } else {
                throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], with unknown parameter [" + fieldName + "]");
            }
            token = parser.nextToken();
        }
        if (scale == null) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected field called [" + SCALE_FIELD.getPreferredName() + "]");
        }
        return new ParsedExponentialHistogram(scale, zeroBucket.threshold(), zeroBucket.count(), negativeBuckets, positiveBuckets, sum, min, max);
    }

    private static double parseDoubleAllowingInfinity(String mappedFieldName, XContentParser parser) throws IOException {
        String text;
        boolean isValidNumber;
        XContentParser.Token token = parser.nextToken();
        boolean bl = isValidNumber = token == XContentParser.Token.VALUE_NUMBER;
        if (token == XContentParser.Token.VALUE_STRING && ((text = parser.text()).equals("-Infinity") || text.equals("Infinity"))) {
            isValidNumber = true;
        }
        if (isValidNumber) {
            return parser.doubleValue();
        }
        throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected a number but got " + String.valueOf(token));
    }

    private static ParsedZeroBucket parseZeroBucket(String mappedFieldName, XContentParser subParser) throws IOException {
        long zeroCount = ParsedZeroBucket.DEFAULT.count();
        double zeroThreshold = ParsedZeroBucket.DEFAULT.threshold();
        XContentParser.Token token = subParser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)subParser);
        token = subParser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)subParser);
            String fieldName = subParser.currentName();
            if (fieldName.equals(ZERO_THRESHOLD_FIELD.getPreferredName())) {
                token = subParser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)subParser);
                zeroThreshold = subParser.doubleValue();
                if (zeroThreshold < 0.0 || !Double.isFinite(zeroThreshold)) {
                    throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], zero.threshold field must be a non-negative, finite number but got " + zeroThreshold);
                }
            } else if (fieldName.equals(ZERO_COUNT_FIELD.getPreferredName())) {
                token = subParser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)subParser);
                zeroCount = subParser.longValue();
                if (zeroCount < 0L) {
                    throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], zero.count field must be a non-negative number but got " + zeroCount);
                }
            } else {
                throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], with unknown parameter for zero sub-object [" + fieldName + "]");
            }
            token = subParser.nextToken();
        }
        return new ParsedZeroBucket(zeroCount, zeroThreshold);
    }

    private static List<IndexWithCount> readAndValidateBuckets(String mappedFieldName, String containerFieldName, XContentParser parser) throws IOException {
        int i;
        XContentParser.Token token = parser.nextToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        token = parser.nextToken();
        List indices = Collections.emptyList();
        List counts = Collections.emptyList();
        while (token != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)parser);
            String fieldName = parser.currentName();
            if (fieldName.equals(BUCKET_INDICES_FIELD.getPreferredName())) {
                indices = new ArrayList();
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
                token = parser.nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                    long index = parser.longValue();
                    if (index < -4611686018427387903L || index > 0x3FFFFFFFFFFFFFFFL) {
                        throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], " + containerFieldName + "." + BUCKET_INDICES_FIELD.getPreferredName() + " values must all be in range [-4611686018427387903, 4611686018427387903] but got " + index);
                    }
                    indices.add(index);
                    token = parser.nextToken();
                }
            } else if (fieldName.equals(BUCKET_COUNTS_FIELD.getPreferredName())) {
                counts = new ArrayList();
                token = parser.nextToken();
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)parser);
                token = parser.nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)parser);
                    long count = parser.longValue();
                    if (count <= 0L) {
                        throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], " + containerFieldName + "." + BUCKET_COUNTS_FIELD.getPreferredName() + " values must all be greater than zero but got " + count);
                    }
                    counts.add(count);
                    token = parser.nextToken();
                }
            } else {
                throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], with unknown parameter for " + containerFieldName + " sub-object [" + fieldName + "]");
            }
            token = parser.nextToken();
        }
        if (indices.size() != counts.size()) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected same length from [" + containerFieldName + "." + BUCKET_INDICES_FIELD.getPreferredName() + "] and [" + containerFieldName + "." + BUCKET_COUNTS_FIELD.getPreferredName() + "] but got [" + indices.size() + " != " + counts.size() + "]");
        }
        ArrayList<IndexWithCount> results = new ArrayList<IndexWithCount>(indices.size());
        for (i = 0; i < indices.size(); ++i) {
            results.add(new IndexWithCount((Long)indices.get(i), (Long)counts.get(i)));
        }
        results.sort(Comparator.comparing(IndexWithCount::index));
        for (i = 1; i < results.size(); ++i) {
            long index = ((IndexWithCount)results.get(i)).index();
            if (index != ((IndexWithCount)results.get(i - 1)).index()) continue;
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + mappedFieldName + "], expected entries of [" + containerFieldName + "." + BUCKET_INDICES_FIELD.getPreferredName() + "] to be unique, but got " + index + " multiple times");
        }
        return results;
    }

    private record ParsedZeroBucket(long count, double threshold) {
        static final ParsedZeroBucket DEFAULT = new ParsedZeroBucket(0L, 0.0);
    }

    public record ParsedExponentialHistogram(int scale, double zeroThreshold, long zeroCount, List<IndexWithCount> negativeBuckets, List<IndexWithCount> positiveBuckets, Double sum, Double min, Double max) {
    }
}

