/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class ResourceUtils {
    static byte[] loadVersionedResourceUTF8(Class<?> clazz, String name, int version, String versionProperty) {
        return ResourceUtils.loadVersionedResourceUTF8(clazz, name, version, versionProperty, Map.of());
    }

    static byte[] loadVersionedResourceUTF8(Class<?> clazz, String name, int version, String versionProperty, Map<String, String> variables) {
        try {
            String content = ResourceUtils.loadResource(clazz, name);
            content = TemplateUtils.replaceVariables(content, String.valueOf(version), versionProperty, variables);
            return content.getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String loadResource(Class<?> clazz, String name) throws IOException {
        try (InputStream is = clazz.getResourceAsStream(name);){
            if (is == null) {
                throw new IOException("Resource [" + name + "] not found in classpath.");
            }
            String string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }
}

