/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ml.action.InferModelAction;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelPrefixStrings;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class CoordinatedInferenceAction
extends ActionType<InferModelAction.Response> {
    public static final CoordinatedInferenceAction INSTANCE = new CoordinatedInferenceAction();
    public static final String NAME = "cluster:internal/xpack/ml/coordinatedinference";

    public CoordinatedInferenceAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest {
        private final String modelId;
        private final RequestModelType requestModelType;
        private final List<String> inputs;
        private final Map<String, Object> taskSettings;
        private final TimeValue inferenceTimeout;
        private final Boolean previouslyLicensed;
        private final InferenceConfigUpdate inferenceConfigUpdate;
        private boolean highPriority;
        private TrainedModelPrefixStrings.PrefixType prefixType = TrainedModelPrefixStrings.PrefixType.NONE;
        private final List<Map<String, Object>> objectsToInfer;

        public static Request forTextInput(String modelId, List<String> inputs, @Nullable InferenceConfigUpdate inferenceConfigUpdate, @Nullable Boolean previouslyLicensed, @Nullable TimeValue inferenceTimeout) {
            return new Request(modelId, inputs, null, null, inferenceConfigUpdate, previouslyLicensed, inferenceTimeout, false, RequestModelType.NLP_MODEL);
        }

        public static Request forMapInput(String modelId, List<Map<String, Object>> objectsToInfer, @Nullable InferenceConfigUpdate inferenceConfigUpdate, @Nullable Boolean previouslyLicensed, @Nullable TimeValue inferenceTimeout, RequestModelType modelType) {
            return new Request(modelId, null, null, objectsToInfer, inferenceConfigUpdate, previouslyLicensed, inferenceTimeout, false, modelType);
        }

        Request(String modelId, @Nullable List<String> inputs, @Nullable Map<String, Object> taskSettings, @Nullable List<Map<String, Object>> objectsToInfer, @Nullable InferenceConfigUpdate inferenceConfigUpdate, @Nullable Boolean previouslyLicensed, @Nullable TimeValue inferenceTimeout, boolean highPriority, RequestModelType requestModelType) {
            this.modelId = ExceptionsHelper.requireNonNull(modelId, "model_id");
            this.inputs = inputs;
            this.taskSettings = taskSettings;
            this.objectsToInfer = objectsToInfer;
            this.inferenceConfigUpdate = inferenceConfigUpdate;
            this.previouslyLicensed = previouslyLicensed;
            this.inferenceTimeout = inferenceTimeout;
            this.highPriority = highPriority;
            this.requestModelType = requestModelType;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.modelId = in.readString();
            this.requestModelType = (RequestModelType)in.readEnum(RequestModelType.class);
            this.inputs = in.readOptionalStringCollectionAsList();
            this.taskSettings = in.readGenericMap();
            this.objectsToInfer = in.readOptionalCollectionAsList(StreamInput::readGenericMap);
            this.inferenceConfigUpdate = (InferenceConfigUpdate)in.readOptionalNamedWriteable(InferenceConfigUpdate.class);
            this.previouslyLicensed = in.readOptionalBoolean();
            this.inferenceTimeout = in.readOptionalTimeValue();
            this.highPriority = in.readBoolean();
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
                this.prefixType = (TrainedModelPrefixStrings.PrefixType)in.readEnum(TrainedModelPrefixStrings.PrefixType.class);
            }
        }

        public String getModelId() {
            return this.modelId;
        }

        public List<String> getInputs() {
            return this.inputs;
        }

        public Map<String, Object> getTaskSettings() {
            return this.taskSettings;
        }

        public List<Map<String, Object>> getObjectsToInfer() {
            return this.objectsToInfer;
        }

        public InferenceConfigUpdate getInferenceConfigUpdate() {
            return this.inferenceConfigUpdate;
        }

        public Boolean getPreviouslyLicensed() {
            return this.previouslyLicensed;
        }

        public TimeValue getInferenceTimeout() {
            return this.inferenceTimeout;
        }

        public boolean getHighPriority() {
            return this.highPriority;
        }

        public void setHighPriority(boolean highPriority) {
            this.highPriority = highPriority;
        }

        public boolean hasInferenceConfig() {
            return this.inferenceConfigUpdate != null;
        }

        public boolean hasObjects() {
            return this.objectsToInfer != null;
        }

        public void setPrefixType(TrainedModelPrefixStrings.PrefixType prefixType) {
            this.prefixType = prefixType;
        }

        public TrainedModelPrefixStrings.PrefixType getPrefixType() {
            return this.prefixType;
        }

        public RequestModelType getRequestModelType() {
            return this.requestModelType;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.modelId);
            out.writeEnum((Enum)this.requestModelType);
            out.writeOptionalStringCollection(this.inputs);
            out.writeGenericMap(this.taskSettings);
            out.writeOptionalCollection(this.objectsToInfer, StreamOutput::writeGenericMap);
            out.writeOptionalNamedWriteable((NamedWriteable)this.inferenceConfigUpdate);
            out.writeOptionalBoolean(this.previouslyLicensed);
            out.writeOptionalTimeValue(this.inferenceTimeout);
            out.writeBoolean(this.highPriority);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
                out.writeEnum((Enum)this.prefixType);
            }
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.modelId, request.modelId) && Objects.equals((Object)this.requestModelType, (Object)request.requestModelType) && Objects.equals(this.inputs, request.inputs) && Objects.equals(this.taskSettings, request.taskSettings) && Objects.equals(this.objectsToInfer, request.objectsToInfer) && Objects.equals(this.inferenceConfigUpdate, request.inferenceConfigUpdate) && Objects.equals(this.previouslyLicensed, request.previouslyLicensed) && Objects.equals(this.inferenceTimeout, request.inferenceTimeout) && Objects.equals(this.highPriority, request.highPriority) && Objects.equals((Object)this.prefixType, (Object)request.prefixType);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.modelId, this.requestModelType, this.inputs, this.taskSettings, this.objectsToInfer, this.inferenceConfigUpdate, this.previouslyLicensed, this.inferenceTimeout, this.highPriority, this.prefixType});
        }

        public static enum RequestModelType {
            INFERENCE_SERVICE_MODEL,
            ML_NODE_PYTORCH_MODEL,
            BOOSTED_TREE_MODEL,
            NLP_MODEL,
            UNKNOWN;

        }
    }
}

