/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class MlMetadata
implements Metadata.ProjectCustom {
    public static final String TYPE = "ml";
    public static final ParseField UPGRADE_MODE = new ParseField("upgrade_mode", new String[0]);
    public static final ParseField RESET_MODE = new ParseField("reset_mode", new String[0]);
    public static final MlMetadata EMPTY_METADATA = new MlMetadata(false, false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = new ObjectParser("ml_metadata", true, Builder::new);
    private final boolean upgradeMode;
    private final boolean resetMode;

    private MlMetadata(boolean upgradeMode, boolean resetMode) {
        this.upgradeMode = upgradeMode;
        this.resetMode = resetMode;
    }

    public boolean isUpgradeMode() {
        return this.upgradeMode;
    }

    public boolean isResetMode() {
        return this.resetMode;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public String getWriteableName() {
        return TYPE;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public Diff<Metadata.ProjectCustom> diff(Metadata.ProjectCustom previousState) {
        return new MlMetadataDiff((MlMetadata)previousState, this);
    }

    public MlMetadata(StreamInput in) throws IOException {
        this.upgradeMode = in.readBoolean();
        this.resetMode = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.upgradeMode);
        out.writeBoolean(this.resetMode);
    }

    private static <T extends Writeable> void writeMap(Map<String, T> map, StreamOutput out) throws IOException {
        out.writeVInt(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            out.writeString(entry.getKey());
            ((Writeable)entry.getValue()).writeTo(out);
        }
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single((builder, params) -> builder.field(UPGRADE_MODE.getPreferredName(), this.upgradeMode).field(RESET_MODE.getPreferredName(), this.resetMode));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MlMetadata that = (MlMetadata)o;
        return this.upgradeMode == that.upgradeMode && this.resetMode == that.resetMode;
    }

    public final String toString() {
        return Strings.toString((ChunkedToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.upgradeMode, this.resetMode);
    }

    @Deprecated(forRemoval=true)
    public static MlMetadata getMlMetadata(ClusterState state) {
        MlMetadata mlMetadata;
        MlMetadata mlMetadata2 = mlMetadata = state == null ? null : (MlMetadata)state.metadata().getSingleProjectCustom(TYPE);
        if (mlMetadata == null) {
            return EMPTY_METADATA;
        }
        return mlMetadata;
    }

    public static MlMetadata getMlMetadata(ProjectMetadata project) {
        MlMetadata mlMetadata;
        MlMetadata mlMetadata2 = mlMetadata = project == null ? null : (MlMetadata)project.custom(TYPE);
        if (mlMetadata == null) {
            return EMPTY_METADATA;
        }
        return mlMetadata;
    }

    static {
        LENIENT_PARSER.declareBoolean(Builder::isUpgradeMode, UPGRADE_MODE);
        LENIENT_PARSER.declareBoolean(Builder::isResetMode, RESET_MODE);
    }

    public static class MlMetadataDiff
    implements NamedDiff<Metadata.ProjectCustom> {
        final boolean upgradeMode;
        final boolean resetMode;

        MlMetadataDiff(MlMetadata before, MlMetadata after) {
            this.upgradeMode = after.upgradeMode;
            this.resetMode = after.resetMode;
        }

        public MlMetadataDiff(StreamInput in) throws IOException {
            this.upgradeMode = in.readBoolean();
            this.resetMode = in.readBoolean();
        }

        public Metadata.ProjectCustom apply(Metadata.ProjectCustom part) {
            return new MlMetadata(this.upgradeMode, this.resetMode);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.upgradeMode);
            out.writeBoolean(this.resetMode);
        }

        public String getWriteableName() {
            return MlMetadata.TYPE;
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersion.minimumCompatible();
        }

        static Diff<Job> readJobDiffFrom(StreamInput in) throws IOException {
            return SimpleDiffable.readDiffFrom(Job::new, (StreamInput)in);
        }

        static Diff<DatafeedConfig> readDatafeedDiffFrom(StreamInput in) throws IOException {
            return SimpleDiffable.readDiffFrom(DatafeedConfig::new, (StreamInput)in);
        }
    }

    public static class Builder {
        private boolean upgradeMode;
        private boolean resetMode;

        public static Builder from(@Nullable MlMetadata previous) {
            return new Builder(previous);
        }

        public Builder() {
        }

        public Builder(@Nullable MlMetadata previous) {
            if (previous != null) {
                this.upgradeMode = previous.upgradeMode;
                this.resetMode = previous.resetMode;
            }
        }

        public Builder isUpgradeMode(boolean isUpgradeMode) {
            this.upgradeMode = isUpgradeMode;
            return this;
        }

        public Builder isResetMode(boolean isResetMode) {
            this.resetMode = isResetMode;
            return this;
        }

        public MlMetadata build() {
            return new MlMetadata(this.upgradeMode, this.resetMode);
        }
    }
}

