/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingByteResults;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingResults;
import org.elasticsearch.xpack.core.ml.inference.results.MlDenseEmbeddingResults;

public record DenseEmbeddingBitResults(List<DenseEmbeddingByteResults.Embedding> embeddings) implements DenseEmbeddingResults<DenseEmbeddingByteResults.Embedding>
{
    public static final String NAME = "text_embedding_service_bit_results";
    public static final String TEXT_EMBEDDING_BITS = "text_embedding_bits";

    public DenseEmbeddingBitResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(DenseEmbeddingByteResults.Embedding::new));
    }

    @Override
    public int getFirstEmbeddingSize() {
        if (this.embeddings.isEmpty()) {
            throw new IllegalStateException("Embeddings list is empty");
        }
        return 8 * this.embeddings.getFirst().values().length;
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.array((String)TEXT_EMBEDDING_BITS, this.embeddings.iterator());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    public String getWriteableName() {
        return NAME;
    }

    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.embeddings.stream().map(embedding -> new MlDenseEmbeddingResults(TEXT_EMBEDDING_BITS, embedding.toDoubleArray(), false)).toList();
    }

    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TEXT_EMBEDDING_BITS, this.embeddings);
        return map;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DenseEmbeddingBitResults that = (DenseEmbeddingBitResults)o;
        return Objects.equals(this.embeddings, that.embeddings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.embeddings);
    }
}

