/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class SwapAliasesAndDeleteSourceIndexStep
extends AsyncActionStep {
    public static final String NAME = "swap-aliases";
    private static final Logger logger = LogManager.getLogger(SwapAliasesAndDeleteSourceIndexStep.class);
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;
    private final boolean createSourceIndexAlias;

    public SwapAliasesAndDeleteSourceIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, String targetIndexPrefix) {
        this(key, nextStepKey, client, (index, lifecycleState) -> targetIndexPrefix + index, true);
    }

    public SwapAliasesAndDeleteSourceIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier, boolean createSourceIndexAlias) {
        super(key, nextStepKey, client);
        this.targetIndexNameSupplier = targetIndexNameSupplier;
        this.createSourceIndexAlias = createSourceIndexAlias;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    BiFunction<String, LifecycleExecutionState, String> getTargetIndexNameSupplier() {
        return this.targetIndexNameSupplier;
    }

    boolean getCreateSourceIndexAlias() {
        return this.createSourceIndexAlias;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        String originalIndex = indexMetadata.getIndex().getName();
        String targetIndexName = this.targetIndexNameSupplier.apply(originalIndex, indexMetadata.getLifecycleExecutionState());
        IndexMetadata targetIndexMetadata = currentState.metadata().index(targetIndexName);
        if (targetIndexMetadata == null) {
            String policyName = indexMetadata.getLifecyclePolicyName();
            String errorMessage = Strings.format((String)"target index [%s] doesn't exist. stopping execution of lifecycle [%s] for index [%s]", (Object[])new Object[]{targetIndexName, policyName, originalIndex});
            logger.debug(errorMessage);
            listener.onFailure((Exception)new IllegalStateException(errorMessage));
            return;
        }
        SwapAliasesAndDeleteSourceIndexStep.deleteSourceIndexAndTransferAliases(this.getClient(currentState.projectId()), indexMetadata, targetIndexName, listener, this.createSourceIndexAlias);
    }

    static void deleteSourceIndexAndTransferAliases(Client client, IndexMetadata sourceIndex, String targetIndex, ActionListener<Void> listener, boolean createSourceIndexAlias) {
        String sourceIndexName = sourceIndex.getIndex().getName();
        IndicesAliasesRequest aliasesRequest = new IndicesAliasesRequest(TimeValue.MAX_VALUE, TimeValue.THIRTY_SECONDS).addAliasAction(IndicesAliasesRequest.AliasActions.removeIndex().index(sourceIndexName));
        if (createSourceIndexAlias) {
            aliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(targetIndex).alias(sourceIndexName));
        }
        sourceIndex.getAliases().values().forEach(aliasMetaDataToAdd -> aliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(targetIndex).alias(aliasMetaDataToAdd.alias()).indexRouting(aliasMetaDataToAdd.indexRouting()).searchRouting(aliasMetaDataToAdd.searchRouting()).filter(aliasMetaDataToAdd.filter() == null ? null : aliasMetaDataToAdd.filter().string()).writeIndex(null).isHidden(aliasMetaDataToAdd.isHidden())));
        client.admin().indices().aliases(aliasesRequest, listener.delegateFailureAndWrap((l, response) -> {
            if (!response.isAcknowledged()) {
                logger.warn("aliases swap from [{}] to [{}] response was not acknowledged", (Object)sourceIndexName, (Object)targetIndex);
            }
            l.onResponse(null);
        }));
    }

    @Override
    public boolean indexSurvives() {
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndexNameSupplier, this.createSourceIndexAlias);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwapAliasesAndDeleteSourceIndexStep other = (SwapAliasesAndDeleteSourceIndexStep)obj;
        return super.equals(obj) && Objects.equals(this.targetIndexNameSupplier, other.targetIndexNameSupplier) && this.createSourceIndexAlias == other.createSourceIndexAlias;
    }
}

