/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class ForceMergeStep
extends AsyncActionStep {
    public static final String NAME = "forcemerge";
    private static final Logger logger = LogManager.getLogger(ForceMergeStep.class);
    private static final BiFunction<String, LifecycleExecutionState, String> DEFAULT_TARGET_INDEX_NAME_SUPPLIER = (indexName, lifecycleState) -> indexName;
    private final int maxNumSegments;
    private final BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier;

    public ForceMergeStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, int maxNumSegments) {
        this(key, nextStepKey, client, maxNumSegments, DEFAULT_TARGET_INDEX_NAME_SUPPLIER);
    }

    public ForceMergeStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, int maxNumSegments, BiFunction<String, LifecycleExecutionState, String> targetIndexNameSupplier) {
        super(key, nextStepKey, client);
        this.maxNumSegments = maxNumSegments;
        this.targetIndexNameSupplier = targetIndexNameSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ProjectState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        String indexName = this.targetIndexNameSupplier.apply(indexMetadata.getIndex().getName(), indexMetadata.getLifecycleExecutionState());
        assert (indexName != null) : "target index name supplier must not return null";
        ForceMergeRequest request = new ForceMergeRequest(new String[]{indexName});
        request.maxNumSegments(this.maxNumSegments);
        this.getClient(currentState.projectId()).admin().indices().forceMerge(request, listener.delegateFailureAndWrap((l, response) -> {
            if (response.getFailedShards() == 0) {
                l.onResponse(null);
            } else {
                DefaultShardOperationFailedException[] failures = response.getShardFailures();
                String policyName = indexMetadata.getLifecyclePolicyName();
                String errorMessage = Strings.format((String)"index [%s] in policy [%s] encountered failures [%s] on step [%s]", (Object[])new Object[]{indexName, policyName, failures == null ? "n/a" : Strings.collectionToDelimitedString(Arrays.stream(failures).map(Strings::toString).toList(), (String)","), NAME});
                logger.warn(errorMessage);
                l.onFailure((Exception)new ElasticsearchException(errorMessage, new Object[0]));
            }
        }));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxNumSegments);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForceMergeStep other = (ForceMergeStep)obj;
        return super.equals(obj) && Objects.equals(this.maxNumSegments, other.maxNumSegments);
    }
}

