/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.ql.expression.gen.processor.BinaryProcessor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringProcessor;

public class ConcatFunctionProcessor
extends BinaryProcessor {
    public static final String NAME = "scon";

    public ConcatFunctionProcessor(Processor source1, Processor source2) {
        super(source1, source2);
    }

    public ConcatFunctionProcessor(StreamInput in) throws IOException {
        super(in);
    }

    public Object process(Object input) {
        Object l = this.left().process(input);
        this.checkParameter(l);
        Object r = this.right().process(input);
        this.checkParameter(r);
        return this.doProcess(l, r);
    }

    protected Object doProcess(Object left, Object right) {
        return ConcatFunctionProcessor.process(left, right);
    }

    public static Object process(Object source1, Object source2) {
        if (source1 == null && source2 == null) {
            return "";
        }
        if (source1 == null) {
            return source2;
        }
        if (source2 == null) {
            return source1;
        }
        if (!(source1 instanceof String || source1 instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", source1);
        }
        if (!(source2 instanceof String || source2 instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", source2);
        }
        String str1 = source1.toString();
        String str2 = source2.toString();
        StringProcessor.checkResultLength(str1.length() + str2.length());
        return str1.concat(str2);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ConcatFunctionProcessor other = (ConcatFunctionProcessor)((Object)obj);
        return Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    public int hashCode() {
        return Objects.hash(this.left(), this.right());
    }

    protected void doWrite(StreamOutput out) throws IOException {
    }
}

