/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference;

import org.elasticsearch.client.internal.Client;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.inference.InferenceResolver;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunner;
import org.elasticsearch.xpack.esql.inference.bulk.BulkInferenceRunnerConfig;

public class InferenceService {
    private final InferenceResolver.Factory inferenceResolverFactory;
    private final BulkInferenceRunner.Factory bulkInferenceRunnerFactory;

    public InferenceService(Client client) {
        this(InferenceResolver.factory(client), BulkInferenceRunner.factory(client));
    }

    private InferenceService(InferenceResolver.Factory inferenceResolverFactory, BulkInferenceRunner.Factory bulkInferenceRunnerFactory) {
        this.inferenceResolverFactory = inferenceResolverFactory;
        this.bulkInferenceRunnerFactory = bulkInferenceRunnerFactory;
    }

    public InferenceResolver inferenceResolver(EsqlFunctionRegistry functionRegistry) {
        return this.inferenceResolverFactory.create(functionRegistry);
    }

    public BulkInferenceRunner bulkInferenceRunner() {
        return this.bulkInferenceRunner(BulkInferenceRunnerConfig.DEFAULT);
    }

    public BulkInferenceRunner bulkInferenceRunner(BulkInferenceRunnerConfig bulkInferenceRunnerConfig) {
        return this.bulkInferenceRunnerFactory.create(bulkInferenceRunnerConfig);
    }
}

