/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.SpatialEnvelopeVisitor;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StXMaxFromWKBEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StXMaxFromWKBGeoEvaluator;

public class StXMax
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "StXMax", StXMax::new);

    @FunctionInfo(returnType={"double"}, preview=true, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW)}, description="Extracts the maximum value of the `x` coordinates from the supplied geometry.\nIf the geometry is of type `geo_point` or `geo_shape` this is equivalent to extracting the maximum `longitude` value.", examples={@Example(file="spatial_shapes", tag="st_x_y_min_max")}, depthOffset=1)
    public StXMax(Source source, @Param(name="point", type={"geo_point", "geo_shape", "cartesian_point", "cartesian_shape"}, description="Expression of type `geo_point`, `geo_shape`, `cartesian_point` or `cartesian_shape`. If `null`, the function returns `null`.") Expression field) {
        super(source, field);
    }

    private StXMax(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return StXMax.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isSpatial(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        if (this.field().dataType() == DataType.GEO_POINT || this.field().dataType() == DataType.GEO_SHAPE) {
            return new StXMaxFromWKBGeoEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
        }
        return new StXMaxFromWKBEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
    }

    @Override
    public DataType dataType() {
        return DataType.DOUBLE;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new StXMax(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, StXMax::new, (Object)this.field());
    }

    static double fromWellKnownBinary(BytesRef wkb) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(wkb);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return point.getX();
        }
        Optional envelope = SpatialEnvelopeVisitor.visitCartesian((Geometry)geometry);
        if (envelope.isPresent()) {
            return ((Rectangle)envelope.get()).getMaxX();
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }

    static double fromWellKnownBinaryGeo(BytesRef wkb) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(wkb);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return point.getX();
        }
        Optional envelope = SpatialEnvelopeVisitor.visitGeo((Geometry)geometry, (SpatialEnvelopeVisitor.WrapLongitude)SpatialEnvelopeVisitor.WrapLongitude.WRAP);
        if (envelope.isPresent()) {
            return ((Rectangle)envelope.get()).getMaxX();
        }
        throw new IllegalArgumentException("Cannot determine envelope of geometry");
    }
}

