/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.xpack.esql.common.spatial.H3SphericalUtil;

public class GeoHexBoundedPredicate {
    private final boolean crossesDateline;
    private final GeoBoundingBox bbox;
    private final GeoBoundingBox scratch;

    GeoHexBoundedPredicate(GeoBoundingBox bbox) {
        this.crossesDateline = bbox.right() < bbox.left();
        this.bbox = bbox;
        this.scratch = new GeoBoundingBox(new GeoPoint(), new GeoPoint());
    }

    public boolean validHex(long hex) {
        H3SphericalUtil.computeGeoBounds(hex, this.scratch);
        if (this.bbox.top() > this.scratch.bottom() && this.bbox.bottom() < this.scratch.top()) {
            if (this.scratch.left() > this.scratch.right()) {
                return this.intersects(-180.0, this.scratch.right()) || this.intersects(this.scratch.left(), 180.0);
            }
            return this.intersects(this.scratch.left(), this.scratch.right());
        }
        return false;
    }

    private boolean intersects(double minLon, double maxLon) {
        if (this.crossesDateline) {
            return this.bbox.left() < maxLon || this.bbox.right() > minLon;
        }
        return this.bbox.left() < maxLon && this.bbox.right() > minLon;
    }
}

