/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.Arrays;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundTo;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble10Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble1Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble2Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble3Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble4Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble5Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble6Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble7Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble8Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDouble9Evaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RoundToDoubleBinarySearchEvaluator;

class RoundToDouble {
    static final RoundTo.Build BUILD = (source, field, points) -> {
        double[] f = points.stream().mapToDouble(p -> ((Number)p).doubleValue()).toArray();
        return switch (f.length) {
            case 1 -> new RoundToDouble1Evaluator.Factory(source, field, f[0]);
            case 2 -> new RoundToDouble2Evaluator.Factory(source, field, f[0], f[1]);
            case 3 -> new RoundToDouble3Evaluator.Factory(source, field, f[0], f[1], f[2]);
            case 4 -> new RoundToDouble4Evaluator.Factory(source, field, f[0], f[1], f[2], f[3]);
            case 5 -> new RoundToDouble5Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4]);
            case 6 -> new RoundToDouble6Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5]);
            case 7 -> new RoundToDouble7Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6]);
            case 8 -> new RoundToDouble8Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7]);
            case 9 -> new RoundToDouble9Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7], f[8]);
            case 10 -> new RoundToDouble10Evaluator.Factory(source, field, f[0], f[1], f[2], f[3], f[4], f[5], f[6], f[7], f[8], f[9]);
            default -> new RoundToDoubleBinarySearchEvaluator.Factory(source, field, f);
        };
    };

    RoundToDouble() {
    }

    static double process(double field, double[] points) {
        int idx = Arrays.binarySearch(points, field);
        return points[idx >= 0 ? idx : Math.max(0, -idx - 2)];
    }

    static double process(double field, double p0) {
        return p0;
    }

    static double process(double field, double p0, double p1) {
        if (field < p1) {
            return p0;
        }
        return p1;
    }

    static double process(double field, double p0, double p1, double p2) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        return p2;
    }

    static double process(double field, double p0, double p1, double p2, double p3) {
        if (field < p1) {
            return p0;
        }
        if (field < p2) {
            return p1;
        }
        if (field < p3) {
            return p2;
        }
        return p3;
    }

    static double process(double field, double p0, double p1, double p2, double p3, double p4) {
        if (field < p2) {
            if (field < p1) {
                return p0;
            }
            return p1;
        }
        if (field < p3) {
            return p2;
        }
        if (field < p4) {
            return p3;
        }
        return p4;
    }

    static double process(double field, double p0, double p1, double p2, double p3, double p4, double p5) {
        if (field < p2) {
            if (field < p1) {
                return p0;
            }
            return p1;
        }
        if (field < p4) {
            if (field < p3) {
                return p2;
            }
            return p3;
        }
        if (field < p5) {
            return p4;
        }
        return p5;
    }

    static double process(double field, double p0, double p1, double p2, double p3, double p4, double p5, double p6) {
        if (field < p3) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            return p2;
        }
        if (field < p5) {
            if (field < p4) {
                return p3;
            }
            return p4;
        }
        if (field < p6) {
            return p5;
        }
        return p6;
    }

    static double process(double field, double p0, double p1, double p2, double p3, double p4, double p5, double p6, double p7) {
        if (field < p3) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            return p2;
        }
        if (field < p5) {
            if (field < p4) {
                return p3;
            }
            return p4;
        }
        if (field < p6) {
            return p5;
        }
        if (field < p7) {
            return p6;
        }
        return p7;
    }

    static double process(double field, double p0, double p1, double p2, double p3, double p4, double p5, double p6, double p7, double p8) {
        if (field < p4) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            if (field < p3) {
                return p2;
            }
            return p3;
        }
        if (field < p6) {
            if (field < p5) {
                return p4;
            }
            return p5;
        }
        if (field < p7) {
            return p6;
        }
        if (field < p8) {
            return p7;
        }
        return p8;
    }

    static double process(double field, double p0, double p1, double p2, double p3, double p4, double p5, double p6, double p7, double p8, double p9) {
        if (field < p4) {
            if (field < p1) {
                return p0;
            }
            if (field < p2) {
                return p1;
            }
            if (field < p3) {
                return p2;
            }
            return p3;
        }
        if (field < p7) {
            if (field < p5) {
                return p4;
            }
            if (field < p6) {
                return p5;
            }
            return p6;
        }
        if (field < p8) {
            return p7;
        }
        if (field < p9) {
            return p8;
        }
        return p9;
    }
}

