/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;

public class PercentileOverTime
extends TimeSeriesAggregateFunction {
    @FunctionInfo(returnType={"double"}, description="Calculates the percentile over time of a numeric field.", type=FunctionType.TIME_SERIES_AGGREGATE, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.3.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="percentile_over_time")})
    public PercentileOverTime(Source source, @Param(name="number", type={"double", "integer", "long"}, description="Expression that outputs values to calculate the percentile of.") Expression field, @Param(name="percentile", type={"double", "integer", "long"}) Expression percentile) {
        this(source, field, (Expression)Literal.TRUE, percentile);
    }

    public PercentileOverTime(Source source, Expression field, Expression filter, Expression percentile) {
        super(source, field, filter, List.of(percentile));
    }

    private PercentileOverTime(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return this.perTimeSeriesAggregation().resolveType();
    }

    public DataType dataType() {
        return this.perTimeSeriesAggregation().dataType();
    }

    protected NodeInfo<PercentileOverTime> info() {
        return NodeInfo.create((Node)this, PercentileOverTime::new, (Object)this.field(), (Object)this.filter(), (Object)((Expression)this.children().get(2)));
    }

    public PercentileOverTime replaceChildren(List<Expression> newChildren) {
        return new PercentileOverTime(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public PercentileOverTime withFilter(Expression filter) {
        return new PercentileOverTime(this.source(), this.field(), filter, (Expression)this.children().get(2));
    }

    @Override
    public AggregateFunction perTimeSeriesAggregation() {
        return new Percentile(this.source(), this.field(), this.filter(), (Expression)this.children().get(2));
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("PercentileOverTime is not directly serializable");
    }
}

