/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.SnapshotMetrics;
import org.elasticsearch.repositories.azure.AzureClientProvider;
import org.elasticsearch.repositories.azure.AzureRepository;
import org.elasticsearch.repositories.azure.AzureStorageService;
import org.elasticsearch.repositories.azure.AzureStorageSettings;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class AzureRepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    public static final String REPOSITORY_THREAD_POOL_NAME = "repository_azure";
    public static final String NETTY_EVENT_LOOP_THREAD_POOL_NAME = "azure_event_loop";
    final SetOnce<AzureStorageService> azureStoreService = new SetOnce();
    private final Settings settings;

    public AzureRepositoryPlugin(Settings settings) {
        AzureStorageSettings.load(settings);
        this.settings = settings;
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, RepositoriesMetrics repositoriesMetrics, SnapshotMetrics snapshotMetrics) {
        return Collections.singletonMap("azure", (projectId, metadata) -> {
            AzureStorageService storageService = (AzureStorageService)this.azureStoreService.get();
            assert (storageService != null);
            return new AzureRepository(projectId, metadata, namedXContentRegistry, storageService, clusterService, bigArrays, recoverySettings, repositoriesMetrics, snapshotMetrics);
        });
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        AzureClientProvider azureClientProvider = AzureClientProvider.create(services.threadPool(), this.settings);
        this.azureStoreService.set((Object)this.createAzureStorageService(this.settings, azureClientProvider, services.clusterService(), services.projectResolver()));
        assert (AzureRepositoryPlugin.assertRepositoryAzureMaxThreads(this.settings, services.threadPool()));
        return List.of(azureClientProvider);
    }

    AzureStorageService createAzureStorageService(Settings settingsToUse, AzureClientProvider azureClientProvider, ClusterService clusterService, ProjectResolver projectResolver) {
        return new AzureStorageService(settingsToUse, azureClientProvider, clusterService, projectResolver);
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(AzureClientProvider.EVENT_LOOP_THREAD_COUNT, AzureClientProvider.MAX_OPEN_CONNECTIONS, AzureClientProvider.OPEN_CONNECTION_TIMEOUT, AzureClientProvider.MAX_IDLE_TIME, AzureStorageSettings.ACCOUNT_SETTING, AzureStorageSettings.KEY_SETTING, AzureStorageSettings.SAS_TOKEN_SETTING, AzureStorageSettings.ENDPOINT_SUFFIX_SETTING, AzureStorageSettings.TIMEOUT_SETTING, AzureStorageSettings.MAX_RETRIES_SETTING, AzureStorageSettings.PROXY_TYPE_SETTING, AzureStorageSettings.PROXY_HOST_SETTING, AzureStorageSettings.PROXY_PORT_SETTING, AzureStorageSettings.ENDPOINT_SETTING, AzureStorageSettings.SECONDARY_ENDPOINT_SETTING);
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return List.of(AzureRepositoryPlugin.executorBuilder(settings), AzureRepositoryPlugin.nettyEventLoopExecutorBuilder(settings));
    }

    public static ExecutorBuilder<?> executorBuilder(Settings settings) {
        int repositoryAzureMax = 5;
        if (DiscoveryNode.isStateless((Settings)settings)) {
            repositoryAzureMax += ThreadPool.getMaxSnapshotThreadPoolSize((int)EsExecutors.allocatedProcessors((Settings)settings));
        }
        return new ScalingExecutorBuilder(REPOSITORY_THREAD_POOL_NAME, 0, repositoryAzureMax, TimeValue.timeValueSeconds((long)30L), false);
    }

    public static ExecutorBuilder<?> nettyEventLoopExecutorBuilder(Settings settings) {
        int eventLoopThreads = AzureClientProvider.eventLoopThreadsFromSettings(settings);
        return new ScalingExecutorBuilder(NETTY_EVENT_LOOP_THREAD_POOL_NAME, 0, eventLoopThreads, TimeValue.timeValueSeconds((long)30L), false);
    }

    public void reload(Settings settingsToLoad) {
        Map<String, AzureStorageSettings> clientsSettings = AzureStorageSettings.load(settingsToLoad);
        AzureStorageService storageService = (AzureStorageService)this.azureStoreService.get();
        assert (storageService != null);
        storageService.refreshClusterClientSettings(clientsSettings);
    }

    private static boolean assertRepositoryAzureMaxThreads(Settings settings, ThreadPool threadPool) {
        if (DiscoveryNode.isStateless((Settings)settings)) {
            int repositoryAzureMax = threadPool.info(REPOSITORY_THREAD_POOL_NAME).getMax();
            int snapshotMax = ThreadPool.getMaxSnapshotThreadPoolSize((int)EsExecutors.allocatedProcessors((Settings)settings));
            assert (snapshotMax < repositoryAzureMax) : "thread pool [repository_azure] should be large enough to allow all " + snapshotMax + " snapshot threads to run at once, but got: " + repositoryAzureMax;
        }
        return true;
    }
}

