/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.voyageai.rerank;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.voyageai.VoyageAIModel;
import org.elasticsearch.xpack.inference.services.voyageai.action.VoyageAIActionVisitor;
import org.elasticsearch.xpack.inference.services.voyageai.rerank.VoyageAIRerankServiceSettings;
import org.elasticsearch.xpack.inference.services.voyageai.rerank.VoyageAIRerankTaskSettings;

public class VoyageAIRerankModel
extends VoyageAIModel {
    public static VoyageAIRerankModel of(VoyageAIRerankModel model, Map<String, Object> taskSettings) {
        VoyageAIRerankTaskSettings requestTaskSettings = VoyageAIRerankTaskSettings.fromMap(taskSettings);
        return new VoyageAIRerankModel(model, VoyageAIRerankTaskSettings.of(model.getTaskSettings(), requestTaskSettings));
    }

    public VoyageAIRerankModel(String inferenceId, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceId, service, VoyageAIRerankServiceSettings.fromMap(serviceSettings, context), VoyageAIRerankTaskSettings.fromMap(taskSettings), DefaultSecretSettings.fromMap(secrets), RequestUtils.buildUri("voyageai", (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)VoyageAIRerankModel::buildRequestUri)));
    }

    public static URI buildRequestUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.voyageai.com").setPathSegments(new String[]{"v1", "rerank"}).build();
    }

    VoyageAIRerankModel(String inferenceId, String service, String url, VoyageAIRerankServiceSettings serviceSettings, VoyageAIRerankTaskSettings taskSettings, @Nullable DefaultSecretSettings secretSettings) {
        this(inferenceId, service, serviceSettings, taskSettings, secretSettings, ServiceUtils.createUri(url));
    }

    private VoyageAIRerankModel(String inferenceId, String service, VoyageAIRerankServiceSettings serviceSettings, VoyageAIRerankTaskSettings taskSettings, @Nullable DefaultSecretSettings secretSettings, URI uri) {
        super(new ModelConfigurations(inferenceId, TaskType.RERANK, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secretSettings), secretSettings, serviceSettings.getCommonSettings(), uri);
    }

    private VoyageAIRerankModel(VoyageAIRerankModel model, VoyageAIRerankTaskSettings taskSettings) {
        super((VoyageAIModel)model, (TaskSettings)taskSettings);
    }

    public VoyageAIRerankServiceSettings getServiceSettings() {
        return (VoyageAIRerankServiceSettings)super.getServiceSettings();
    }

    public VoyageAIRerankTaskSettings getTaskSettings() {
        return (VoyageAIRerankTaskSettings)super.getTaskSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public ExecutableAction accept(VoyageAIActionVisitor visitor, Map<String, Object> taskSettings) {
        return visitor.create(this, taskSettings);
    }
}

