/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.ibmwatsonx.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.IbmWatsonxModel;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.action.IbmWatsonxActionVisitor;
import org.elasticsearch.xpack.inference.services.ibmwatsonx.completion.IbmWatsonxChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class IbmWatsonxChatCompletionModel
extends IbmWatsonxModel {
    public IbmWatsonxChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, IbmWatsonxChatCompletionServiceSettings.fromMap(serviceSettings, context), DefaultSecretSettings.fromMap(secrets));
    }

    public static IbmWatsonxChatCompletionModel of(IbmWatsonxChatCompletionModel model, UnifiedCompletionRequest request) {
        if (request.model() == null) {
            return model;
        }
        IbmWatsonxChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        IbmWatsonxChatCompletionServiceSettings overriddenServiceSettings = new IbmWatsonxChatCompletionServiceSettings(originalModelServiceSettings.uri(), originalModelServiceSettings.apiVersion(), request.model(), originalModelServiceSettings.projectId(), originalModelServiceSettings.rateLimitSettings());
        return new IbmWatsonxChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), overriddenServiceSettings, model.getSecretSettings());
    }

    IbmWatsonxChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, IbmWatsonxChatCompletionServiceSettings serviceSettings, @Nullable DefaultSecretSettings secretSettings) {
        super(new ModelConfigurations(inferenceEntityId, taskType, service, (ServiceSettings)serviceSettings), new ModelSecrets((SecretSettings)secretSettings), serviceSettings);
    }

    public IbmWatsonxChatCompletionServiceSettings getServiceSettings() {
        return (IbmWatsonxChatCompletionServiceSettings)super.getServiceSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    public URI uri() {
        URI uri;
        try {
            uri = IbmWatsonxChatCompletionModel.buildUri(this.getServiceSettings().uri().toString(), this.getServiceSettings().apiVersion());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uri;
    }

    @Override
    public ExecutableAction accept(IbmWatsonxActionVisitor visitor, Map<String, Object> taskSettings) {
        return visitor.create(this);
    }

    public static URI buildUri(String uri, String apiVersion) throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost(uri).setPathSegments(new String[]{"ml", "v1", "text", "chat"}).setParameter("version", apiVersion).build();
    }
}

