/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googleaistudio.response;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.results.DenseEmbeddingFloatResults;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.XContentUtils;

public class GoogleAiStudioEmbeddingsResponseEntity {
    private static final String FAILED_TO_FIND_FIELD_TEMPLATE = "Failed to find required field [%s] in Google AI Studio embeddings response";

    public static DenseEmbeddingFloatResults fromResponse(Request request, HttpResult response) throws IOException {
        XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);
        try (XContentParser jsonParser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(parserConfig, response.body());){
            XContentUtils.moveToFirstToken(jsonParser);
            XContentParser.Token token = jsonParser.currentToken();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)jsonParser);
            XContentUtils.positionParserAtTokenAfterField(jsonParser, "embeddings", FAILED_TO_FIND_FIELD_TEMPLATE);
            List embeddingList = XContentParserUtils.parseList((XContentParser)jsonParser, GoogleAiStudioEmbeddingsResponseEntity::parseEmbeddingObject);
            DenseEmbeddingFloatResults denseEmbeddingFloatResults = new DenseEmbeddingFloatResults(embeddingList);
            return denseEmbeddingFloatResults;
        }
    }

    private static DenseEmbeddingFloatResults.Embedding parseEmbeddingObject(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentUtils.positionParserAtTokenAfterField(parser, "values", FAILED_TO_FIND_FIELD_TEMPLATE);
        List embeddingValuesList = XContentParserUtils.parseList((XContentParser)parser, XContentUtils::parseFloat);
        XContentUtils.consumeUntilObjectEnd(parser);
        return DenseEmbeddingFloatResults.Embedding.of((List)embeddingValuesList);
    }

    private GoogleAiStudioEmbeddingsResponseEntity() {
    }
}

