/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.secrets.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class PutConnectorSecretRequest
extends LegacyActionRequest
implements ToXContentObject {
    private final String id;
    private final String value;
    public static final ConstructingObjectParser<PutConnectorSecretRequest, String> PARSER = new ConstructingObjectParser("connector_secret_put_request", false, (args, id) -> new PutConnectorSecretRequest((String)id, (String)args[0]));

    public PutConnectorSecretRequest(String id, String value) {
        this.id = id;
        this.value = value;
    }

    public PutConnectorSecretRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.value = in.readString();
    }

    public static PutConnectorSecretRequest fromXContentBytes(String id, BytesReference source, XContentType xContentType) {
        PutConnectorSecretRequest putConnectorSecretRequest;
        block8: {
            XContentParser parser = XContentHelper.createParser((XContentParserConfiguration)XContentParserConfiguration.EMPTY, (BytesReference)source, (XContentType)xContentType);
            try {
                putConnectorSecretRequest = PutConnectorSecretRequest.fromXContent(parser, id);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("Failed to parse: " + source.utf8ToString(), (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return putConnectorSecretRequest;
    }

    public static PutConnectorSecretRequest fromXContent(XContentParser parser, String id) throws IOException {
        return (PutConnectorSecretRequest)((Object)PARSER.parse(parser, (Object)id));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("value", this.value);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeString(this.value);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException exception = null;
        if (Strings.isNullOrEmpty((String)this.id())) {
            exception = ValidateActions.addValidationError((String)"[id] cannot be [null] or [\"\"]", exception);
        }
        if (Strings.isNullOrEmpty((String)this.value())) {
            exception = ValidateActions.addValidationError((String)"[value] cannot be [null] or [\"\"]", (ActionRequestValidationException)exception);
        }
        return exception;
    }

    public String id() {
        return this.id;
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PutConnectorSecretRequest request = (PutConnectorSecretRequest)((Object)o);
        return Objects.equals(this.id, request.id) && Objects.equals(this.value, request.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("value", new String[0]));
    }
}

