/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.packageloader.action;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Strings;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ModelPackageConfig;
import org.elasticsearch.xpack.core.ml.packageloader.action.GetTrainedModelPackageConfigAction;
import org.elasticsearch.xpack.ml.packageloader.MachineLearningPackageLoader;
import org.elasticsearch.xpack.ml.packageloader.action.ModelLoaderUtils;

public class TransportGetTrainedModelPackageConfigAction
extends TransportMasterNodeAction<GetTrainedModelPackageConfigAction.Request, GetTrainedModelPackageConfigAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetTrainedModelPackageConfigAction.class);

    @Inject
    public TransportGetTrainedModelPackageConfigAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super("cluster:internal/xpack/ml/trained_models/package_loader/get_config", transportService, clusterService, threadPool, actionFilters, GetTrainedModelPackageConfigAction.Request::new, GetTrainedModelPackageConfigAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, GetTrainedModelPackageConfigAction.Request request, ClusterState state, ActionListener<GetTrainedModelPackageConfigAction.Response> listener) throws Exception {
        String repository = (String)this.clusterService.getClusterSettings().get(MachineLearningPackageLoader.MODEL_REPOSITORY);
        String packagedModelId = request.getPackagedModelId();
        logger.debug(() -> Strings.format((String)"Fetch package manifest for [%s] from [%s]", (Object[])new Object[]{packagedModelId, repository}));
        this.threadPool.executor("model_download").execute(() -> {
            try {
                URI uri = ModelLoaderUtils.resolvePackageLocation(repository, packagedModelId + ModelLoaderUtils.METADATA_FILE_EXTENSION);
                InputStream inputStream = ModelLoaderUtils.getInputStreamFromModelRepository(uri);
                try (XContentParser parser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, inputStream.readAllBytes());){
                    ModelPackageConfig packageConfig = ModelPackageConfig.fromXContentLenient((XContentParser)parser);
                    if (!packagedModelId.equals(packageConfig.getPackagedModelId())) {
                        listener.onFailure((Exception)new ElasticsearchStatusException("Invalid package name", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        return;
                    }
                    if (packageConfig.getSize() <= 0L) {
                        listener.onFailure((Exception)new ElasticsearchStatusException("Invalid package size", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        return;
                    }
                    if (org.elasticsearch.common.Strings.isNullOrEmpty((String)packageConfig.getSha256()) || packageConfig.getSha256().length() != 64) {
                        listener.onFailure((Exception)new ElasticsearchStatusException("Invalid package sha", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                        return;
                    }
                    ModelPackageConfig withRepository = new ModelPackageConfig.Builder(packageConfig).setModelRepository(repository).build();
                    listener.onResponse((Object)new GetTrainedModelPackageConfigAction.Response(withRepository));
                }
            }
            catch (MalformedURLException e) {
                listener.onFailure((Exception)new IllegalArgumentException("Invalid connection configuration: " + e.getMessage(), e));
            }
            catch (URISyntaxException e) {
                listener.onFailure((Exception)new IllegalArgumentException("Invalid connection configuration: " + e.getMessage(), e));
            }
            catch (ResourceNotFoundException e) {
                listener.onFailure((Exception)new IllegalArgumentException("Failed to find package", e));
            }
            catch (Exception e) {
                listener.onFailure((Exception)new IllegalArgumentException("Failed to load package metadata", e));
            }
        });
    }

    protected ClusterBlockException checkBlock(GetTrainedModelPackageConfigAction.Request request, ClusterState state) {
        return null;
    }
}

