/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.spi;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.painless.spi.WhitelistConstructor;
import org.elasticsearch.painless.spi.WhitelistField;
import org.elasticsearch.painless.spi.WhitelistMethod;

public final class WhitelistClass {
    public final String origin;
    public final String javaClassName;
    public final List<WhitelistConstructor> whitelistConstructors;
    public final List<WhitelistMethod> whitelistMethods;
    public final List<WhitelistField> whitelistFields;
    public final Map<Class<?>, Object> painlessAnnotations;

    public WhitelistClass(String origin, String javaClassName, List<WhitelistConstructor> whitelistConstructors, List<WhitelistMethod> whitelistMethods, List<WhitelistField> whitelistFields, List<Object> painlessAnnotations) {
        this.origin = Objects.requireNonNull(origin);
        this.javaClassName = Objects.requireNonNull(javaClassName);
        this.whitelistConstructors = List.copyOf(whitelistConstructors);
        this.whitelistMethods = List.copyOf(whitelistMethods);
        this.whitelistFields = List.copyOf(whitelistFields);
        this.painlessAnnotations = painlessAnnotations.stream().collect(Collectors.toUnmodifiableMap(Object::getClass, Function.identity()));
    }
}

