/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.nio.charset.StandardCharsets;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.nativeaccess.CloseableByteBuffer;
import org.elasticsearch.nativeaccess.lib.PosixCLibrary;

public class Systemd {
    private static final Logger logger = LogManager.getLogger(Systemd.class);
    private final PosixCLibrary libc;
    private final String socketPath;
    private final CloseableByteBuffer buffer;

    Systemd(PosixCLibrary libc, String socketPath, CloseableByteBuffer buffer) {
        this.libc = libc;
        this.socketPath = socketPath;
        this.buffer = buffer;
    }

    public void notify_ready() {
        this.notify("READY=1", false);
    }

    public void notify_extend_timeout(long seconds) {
        this.notify("EXTEND_TIMEOUT_USEC=" + seconds * 1000000L, true);
    }

    public void notify_stopping() {
        this.notify("STOPPING=1", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(String state, boolean warnOnError) {
        int sockfd = this.libc.socket(1, 2, 0);
        if (sockfd < 0) {
            this.throwOrLog("Could not open systemd socket: " + this.libc.strerror(this.libc.errno()), warnOnError);
            return;
        }
        RuntimeException error = null;
        try {
            long bytesSent;
            PosixCLibrary.SockAddr sockAddr = this.libc.newUnixSockAddr(this.socketPath);
            if (this.libc.connect(sockfd, sockAddr) != 0) {
                this.throwOrLog("Could not connect to systemd socket: " + this.libc.strerror(this.libc.errno()), warnOnError);
                return;
            }
            byte[] bytes = state.getBytes(StandardCharsets.US_ASCII);
            CloseableByteBuffer closeableByteBuffer = this.buffer;
            synchronized (closeableByteBuffer) {
                this.buffer.buffer().clear();
                this.buffer.buffer().put(0, bytes);
                this.buffer.buffer().limit(bytes.length);
                bytesSent = this.libc.send(sockfd, this.buffer, 0);
            }
            if (bytesSent == -1L) {
                this.throwOrLog("Failed to send message (" + state + ") to systemd socket: " + this.libc.strerror(this.libc.errno()), warnOnError);
            } else if (bytesSent != (long)bytes.length) {
                this.throwOrLog("Not all bytes of message (" + state + ") sent to systemd socket (sent " + bytesSent + ")", warnOnError);
            } else {
                logger.trace("Message (" + state + ") sent to systemd");
            }
        }
        catch (RuntimeException e) {
            error = e;
        }
        finally {
            if (this.libc.close(sockfd) != 0) {
                try {
                    this.throwOrLog("Could not close systemd socket: " + this.libc.strerror(this.libc.errno()), warnOnError);
                }
                catch (RuntimeException e) {
                    if (error != null) {
                        error.addSuppressed(e);
                        throw error;
                    }
                    throw e;
                }
            } else if (error != null) {
                throw error;
            }
        }
    }

    private void throwOrLog(String message, boolean warnOnError) {
        if (!warnOnError) {
            logger.error(message);
            throw new RuntimeException(message);
        }
        logger.warn(message);
    }
}

