/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.ilm.IndexLifecycleClusterStateUpdateTask;
import org.elasticsearch.xpack.ilm.IndexLifecycleTransition;

public class SetStepInfoUpdateTask
extends IndexLifecycleClusterStateUpdateTask {
    private static final Logger logger = LogManager.getLogger(SetStepInfoUpdateTask.class);
    private final String policy;
    private final ToXContentObject stepInfo;

    public SetStepInfoUpdateTask(ProjectId projectId, Index index, String policy, Step.StepKey currentStepKey, ToXContentObject stepInfo) {
        super(projectId, index, currentStepKey);
        this.policy = policy;
        this.stepInfo = stepInfo;
    }

    String getPolicy() {
        return this.policy;
    }

    ToXContentObject getStepInfo() {
        return this.stepInfo;
    }

    @Override
    protected ClusterState doExecute(ProjectState currentState) throws IOException {
        IndexMetadata idxMeta = currentState.metadata().index(this.index);
        if (idxMeta == null) {
            return currentState.cluster();
        }
        LifecycleExecutionState lifecycleState = idxMeta.getLifecycleExecutionState();
        if (this.policy.equals(idxMeta.getLifecyclePolicyName()) && Objects.equals(this.currentStepKey, Step.getCurrentStepKey((LifecycleExecutionState)lifecycleState))) {
            return currentState.updatedState(IndexLifecycleTransition.addStepInfoToProject(this.index, currentState.metadata(), this.stepInfo));
        }
        return currentState.cluster();
    }

    @Override
    public void handleFailure(Exception e) {
        logger.warn(() -> Strings.format((String)"policy [%s] for index [%s] failed trying to set step info for step [%s].", (Object[])new Object[]{this.policy, this.index, this.currentStepKey}), (Throwable)e);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetStepInfoUpdateTask that = (SetStepInfoUpdateTask)o;
        return this.index.equals((Object)that.index) && this.policy.equals(that.policy) && this.currentStepKey.equals((Object)that.currentStepKey) && Objects.equals(this.stepInfo, that.stepInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.policy, this.currentStepKey, this.stepInfo);
    }

    public static class ExceptionWrapper
    implements ToXContentObject {
        private final Throwable exception;

        public ExceptionWrapper(Throwable exception) {
            this.exception = exception;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.exception);
            builder.endObject();
            return builder;
        }
    }
}

