/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.analysis;

import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.eql.plan.logical.KeyedFilter;
import org.elasticsearch.xpack.eql.plan.logical.LimitWithOffset;
import org.elasticsearch.xpack.eql.plan.logical.Sample;
import org.elasticsearch.xpack.eql.plan.logical.Sequence;
import org.elasticsearch.xpack.eql.session.EqlConfiguration;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.Project;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeUtils;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class PostAnalyzer {
    private static final Logger log = LogManager.getLogger(PostAnalyzer.class);

    public LogicalPlan postAnalyze(LogicalPlan plan, EqlConfiguration configuration) {
        LogicalPlan initial = plan;
        if (plan.analyzed()) {
            Source projectCtx = Source.synthetic((String)"<implicit-project>");
            boolean isSequence = plan.anyMatch(Sequence.class::isInstance);
            boolean isSample = plan.anyMatch(Sample.class::isInstance);
            plan = isSequence || isSample ? (LogicalPlan)plan.transformUp(KeyedFilter.class, k -> {
                Object newPlan = new Project(projectCtx, k.child(), isSequence ? k.extractionAttributes() : k.keys());
                if (isSequence) {
                    newPlan = new LimitWithOffset(Source.synthetic((String)"<fetch-size>"), (Expression)new Literal(Source.synthetic((String)"<fetch-value>"), (Object)configuration.fetchSize(), DataTypes.INTEGER), (LogicalPlan)newPlan);
                }
                return new KeyedFilter(k.source(), (LogicalPlan)newPlan, k.keys(), k.timestamp(), k.tiebreaker(), k.isMissingEventFilter());
            }) : new Project(projectCtx, plan, Collections.emptyList());
        }
        if (log.isTraceEnabled()) {
            log.trace("Applied post-analysys\n{}", (Object)NodeUtils.diffString((Node)initial, (Node)plan));
        }
        return plan;
    }
}

