/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.analysis;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.elasticsearch.xpack.eql.analysis.AnalysisUtils;
import org.elasticsearch.xpack.eql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.eql.analysis.VerificationException;
import org.elasticsearch.xpack.eql.analysis.Verifier;
import org.elasticsearch.xpack.eql.expression.OptionalMissingAttribute;
import org.elasticsearch.xpack.eql.expression.OptionalUnresolvedAttribute;
import org.elasticsearch.xpack.ql.analyzer.AnalyzerRules;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.rule.RuleExecutor;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Analyzer
extends ParameterizedRuleExecutor<LogicalPlan, AnalyzerContext> {
    private static final Iterable<RuleExecutor.Batch<LogicalPlan>> rules;
    private final Verifier verifier;

    public Analyzer(AnalyzerContext context, Verifier verifier) {
        super((Object)context);
        this.verifier = verifier;
    }

    protected Iterable<RuleExecutor.Batch<LogicalPlan>> batches() {
        return rules;
    }

    public LogicalPlan analyze(LogicalPlan plan) {
        return this.verify((LogicalPlan)this.execute((Node)plan));
    }

    private LogicalPlan verify(LogicalPlan plan) {
        Collection<Failure> failures = this.verifier.verify(plan);
        if (!failures.isEmpty()) {
            throw new VerificationException(failures);
        }
        return plan;
    }

    static {
        RuleExecutor.Batch optional = new RuleExecutor.Batch("Optional", RuleExecutor.Limiter.ONCE, new Rule[]{new ResolveOrReplaceOptionalRefs()});
        RuleExecutor.Batch resolution = new RuleExecutor.Batch("Resolution", new Rule[]{new ResolveRefs(), new ResolveFunctions()});
        RuleExecutor.Batch cleanup = new RuleExecutor.Batch("Finish Analysis", RuleExecutor.Limiter.ONCE, new Rule[]{new AnalyzerRules.AddMissingEqualsToBoolField()});
        rules = Arrays.asList(optional, resolution, cleanup);
    }

    private static class ResolveOrReplaceOptionalRefs
    extends AnalyzerRules.AnalyzerRule<LogicalPlan> {
        private ResolveOrReplaceOptionalRefs() {
        }

        protected boolean skipResolved() {
            return false;
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            return (LogicalPlan)plan.transformExpressionsUp(OptionalUnresolvedAttribute.class, u -> {
                LinkedHashSet<Attribute> resolvedChildrenOutput = new LinkedHashSet<Attribute>();
                for (LogicalPlan child : plan.children()) {
                    for (Attribute out : child.output()) {
                        if (!out.resolved()) continue;
                        resolvedChildrenOutput.addAll(child.output());
                    }
                }
                Object resolved = AnalysisUtils.resolveAgainstList(u, resolvedChildrenOutput);
                if (resolved != null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Resolved {} to {}", (Object)u, resolved);
                    }
                } else {
                    resolved = plan instanceof Filter ? new Literal(u.source(), null, DataTypes.NULL) : new OptionalMissingAttribute(u.source(), u.name(), u.qualifier());
                }
                return resolved;
            });
        }
    }

    private static class ResolveRefs
    extends AnalyzerRules.AnalyzerRule<LogicalPlan> {
        private ResolveRefs() {
        }

        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Attempting to resolve {}", (Object)plan.nodeString());
            }
            return (LogicalPlan)plan.transformExpressionsUp(UnresolvedAttribute.class, u -> {
                LinkedHashSet<Attribute> childrenOutput = new LinkedHashSet<Attribute>();
                for (LogicalPlan child : plan.children()) {
                    childrenOutput.addAll(child.output());
                }
                Attribute named = AnalysisUtils.resolveAgainstList(u, childrenOutput);
                if (named != null) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Resolved {} to {}", u, (Object)named);
                    }
                    return named;
                }
                return u;
            });
        }
    }

    private static class ResolveFunctions
    extends AnalyzerRules.ParameterizedAnalyzerRule<LogicalPlan, AnalyzerContext> {
        private ResolveFunctions() {
        }

        protected LogicalPlan rule(LogicalPlan plan, AnalyzerContext context) {
            return (LogicalPlan)plan.transformExpressionsUp(UnresolvedFunction.class, uf -> AnalyzerRules.resolveFunction((UnresolvedFunction)uf, (Configuration)context.configuration(), (FunctionRegistry)context.functionRegistry()));
        }
    }
}

