/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.ImplUtils;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataContentType;
import com.azure.core.implementation.util.IterableOfByteBuffersInputStream;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ListByteBufferContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(ListByteBufferContent.class);
    private final List<ByteBuffer> content;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<ListByteBufferContent, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ListByteBufferContent.class, byte[].class, "bytes");
    private Long cachedLength;

    public ListByteBufferContent(List<ByteBuffer> content) {
        this.content = Objects.requireNonNull(content, "'content' cannot be null.");
    }

    @Override
    public Long getLength() {
        if (this.cachedLength == null) {
            this.cachedLength = this.content.stream().mapToLong(Buffer::remaining).sum();
        }
        return this.cachedLength;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return new IterableOfByteBuffersInputStream(this.content);
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return Flux.fromIterable(this.content).map(ByteBuffer::asReadOnlyBuffer);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        for (ByteBuffer bb : this.content) {
            ImplUtils.writeByteBufferToStream(bb.asReadOnlyBuffer(), outputStream);
        }
    }

    @Override
    public void writeTo(WritableByteChannel channel) throws IOException {
        for (ByteBuffer bb : this.content) {
            ImplUtils.fullyWriteBuffer(bb.asReadOnlyBuffer(), channel);
        }
    }

    @Override
    public Mono<Void> writeTo(AsynchronousByteChannel channel) {
        if (channel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return FluxUtil.writeToAsynchronousByteChannel(this.toFluxByteBuffer(), channel);
    }

    @Override
    public boolean isReplayable() {
        return true;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        return this;
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        return Mono.just((Object)this);
    }

    @Override
    public BinaryDataContentType getContentType() {
        return BinaryDataContentType.BINARY;
    }

    private byte[] getBytes() {
        long length = this.getLength();
        if (length > 0x7FFFFFF7L) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("The content length is too large for a byte array. Content length is: " + length));
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        for (ByteBuffer bb : this.content) {
            bb = bb.duplicate();
            int count = bb.remaining();
            bb.get(bytes, offset, count);
            offset += count;
        }
        return bytes;
    }
}

