/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shutdown;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.plugins.ShutdownAwarePlugin;

public class PluginShutdownService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(PluginShutdownService.class);
    public List<ShutdownAwarePlugin> plugins;

    public PluginShutdownService(@Nullable List<ShutdownAwarePlugin> plugins) {
        this.plugins = plugins == null ? Collections.emptyList() : plugins;
    }

    public static Set<String> shutdownNodes(ClusterState clusterState) {
        return clusterState.metadata().nodeShutdowns().getAllNodeIds();
    }

    public static boolean isLocalNodeShutdown(ClusterState clusterState) {
        String localNodeId = clusterState.nodes().getLocalNodeId();
        return localNodeId != null && PluginShutdownService.shutdownNodes(clusterState).contains(localNodeId);
    }

    public static Set<String> shutdownTypeNodes(ClusterState clusterState, SingleNodeShutdownMetadata.Type ... shutdownTypes) {
        Set types = Arrays.stream(shutdownTypes).collect(Collectors.toSet());
        return clusterState.metadata().nodeShutdowns().getAll().entrySet().stream().filter(e -> types.contains((Object)((SingleNodeShutdownMetadata)e.getValue()).getType())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean readyToShutdown(String nodeId, SingleNodeShutdownMetadata.Type shutdownType) {
        for (ShutdownAwarePlugin plugin : this.plugins) {
            try {
                if (plugin.safeToShutdown(nodeId, shutdownType)) continue;
                logger.trace("shutdown aware plugin [{}] is not yet ready for shutdown", (Object)plugin);
                return false;
            }
            catch (Exception e) {
                logger.warn("uncaught exception when retrieving whether plugin is ready for node shutdown", (Throwable)e);
            }
        }
        return true;
    }

    public void signalShutdown(ClusterState state) {
        Set<String> shutdownNodes = PluginShutdownService.shutdownNodes(state);
        for (ShutdownAwarePlugin plugin : this.plugins) {
            try {
                plugin.signalShutdown(shutdownNodes);
            }
            catch (Exception e) {
                logger.warn(() -> "uncaught exception when notifying plugins of nodes " + String.valueOf(shutdownNodes) + " shutdown", (Throwable)e);
            }
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        this.signalShutdown(event.state());
    }
}

