/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.crossproject;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.crossproject.ProjectRoutingInfo;

public class CrossProjectRoutingResolver {
    private static final String ALIAS = "_alias:";
    private static final String ORIGIN = "_origin";
    private static final int ALIAS_LENGTH = "_alias:".length();
    private static final String ALIAS_MATCH_ALL = "_alias:*";
    private static final String ALIAS_MATCH_ORIGIN = "_alias:_origin";
    private static final Set<Character> UNSUPPORTED_CHARACTERS = Set.of(Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('='), Character.valueOf('&'), Character.valueOf('|'), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('!'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('^'), Character.valueOf('\"'), Character.valueOf('~'), Character.valueOf('?'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('/'));

    public List<ProjectRoutingInfo> resolve(String projectRouting, ProjectRoutingInfo originProject, List<ProjectRoutingInfo> candidateProjects) {
        assert (!originProject.projectAlias().equalsIgnoreCase(ORIGIN)) : "origin project alias must not be _origin";
        Stream<ProjectRoutingInfo> candidateProjectStream = candidateProjects.stream().peek(candidateProject -> {
            assert (!candidateProject.projectAlias().equalsIgnoreCase(ORIGIN)) : "project alias must not be _origin";
        }).filter(candidateProject -> {
            assert (!candidateProject.equals(originProject)) : "origin project must not be in the candidateProjects list";
            return !candidateProject.equals(originProject);
        });
        if (ALIAS_MATCH_ORIGIN.equalsIgnoreCase(projectRouting)) {
            return List.of(originProject);
        }
        if (projectRouting == null || projectRouting.isEmpty() || ALIAS_MATCH_ALL.equalsIgnoreCase(projectRouting)) {
            return Stream.concat(Stream.of(originProject), candidateProjectStream).toList();
        }
        CrossProjectRoutingResolver.validateProjectRouting(projectRouting);
        Predicate<ProjectRoutingInfo> matchesSpecifiedRoute = CrossProjectRoutingResolver.createRoutingEntryFilter(projectRouting);
        return Stream.concat(Stream.of(originProject), candidateProjectStream).filter(matchesSpecifiedRoute).toList();
    }

    private static void validateProjectRouting(String projectRouting) {
        boolean startsWithAlias = CrossProjectRoutingResolver.startsWithIgnoreCase(ALIAS, projectRouting);
        if (startsWithAlias && projectRouting.length() == ALIAS_LENGTH) {
            throw new ElasticsearchStatusException("project_routing expression [{}] cannot be empty", RestStatus.BAD_REQUEST, projectRouting);
        }
        if (!startsWithAlias && projectRouting.contains(":")) {
            throw new ElasticsearchStatusException("Unsupported tag [{}] in project_routing expression [{}]. Supported tags [_alias].", RestStatus.BAD_REQUEST, projectRouting.substring(0, projectRouting.indexOf(":")), projectRouting);
        }
        if (!startsWithAlias) {
            throw new ElasticsearchStatusException("project_routing [{}] must start with the prefix [_alias:]", RestStatus.BAD_REQUEST, projectRouting);
        }
    }

    private static Predicate<ProjectRoutingInfo> createRoutingEntryFilter(String projectRouting) {
        boolean matchPrefix = projectRouting.charAt(projectRouting.length() - 1) == '*';
        boolean matchSuffix = projectRouting.charAt(ALIAS_LENGTH) == '*';
        int foundAsterix = -1;
        int startIndex = matchSuffix ? ALIAS_LENGTH + 1 : ALIAS_LENGTH;
        int endIndex = matchPrefix ? projectRouting.length() - 1 : projectRouting.length();
        for (int i = startIndex; i < endIndex; ++i) {
            char nextChar = projectRouting.charAt(i);
            if (Character.isWhitespace(nextChar) || UNSUPPORTED_CHARACTERS.contains(Character.valueOf(nextChar)) || nextChar == '*' && (foundAsterix >= 0 || matchPrefix || matchSuffix)) {
                throw new ElasticsearchStatusException("Unsupported project_routing expression [{}]. Tech Preview only supports project routing via a single project alias or wildcard alias expression", RestStatus.BAD_REQUEST, projectRouting.substring(ALIAS_LENGTH));
            }
            if (nextChar != '*') continue;
            foundAsterix = i;
        }
        if (foundAsterix >= 0) {
            String prefix = projectRouting.substring(startIndex, foundAsterix);
            String suffix = projectRouting.substring(foundAsterix + 1, endIndex);
            return possibleRoute -> CrossProjectRoutingResolver.startsWithIgnoreCase(prefix, possibleRoute.projectAlias()) && CrossProjectRoutingResolver.endsWithIgnoreCase(suffix, possibleRoute.projectAlias());
        }
        String routingEntry = projectRouting.substring(startIndex, endIndex);
        if (matchPrefix && matchSuffix) {
            return possibleRoute -> CrossProjectRoutingResolver.containsIgnoreCase(routingEntry, possibleRoute.projectAlias());
        }
        if (matchPrefix) {
            return possibleRoute -> CrossProjectRoutingResolver.startsWithIgnoreCase(routingEntry, possibleRoute.projectAlias());
        }
        if (matchSuffix) {
            return possibleRoute -> CrossProjectRoutingResolver.endsWithIgnoreCase(routingEntry, possibleRoute.projectAlias());
        }
        return possibleRoute -> possibleRoute.projectAlias().equalsIgnoreCase(routingEntry);
    }

    private static boolean startsWithIgnoreCase(String prefix, String str) {
        if (prefix == null || str == null) {
            return false;
        }
        if (str.startsWith(prefix)) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        if (str.length() == prefix.length() && str.equalsIgnoreCase(prefix)) {
            return true;
        }
        return str.substring(0, prefix.length()).equalsIgnoreCase(prefix);
    }

    private static boolean endsWithIgnoreCase(String suffix, String str) {
        if (suffix == null || str == null) {
            return false;
        }
        if (str.endsWith(suffix)) {
            return true;
        }
        if (str.length() < suffix.length()) {
            return false;
        }
        if (str.length() == suffix.length() && str.equalsIgnoreCase(suffix)) {
            return true;
        }
        return str.substring(str.length() - suffix.length()).equalsIgnoreCase(suffix);
    }

    private static boolean containsIgnoreCase(String substring, String str) {
        if (substring == null || str == null) {
            return false;
        }
        if (str.contains(substring)) {
            return true;
        }
        if (str.length() < substring.length()) {
            return false;
        }
        if (str.length() == substring.length() && str.equalsIgnoreCase(substring)) {
            return true;
        }
        int substringLength = substring.length();
        return IntStream.range(0, str.length() - substringLength).anyMatch(i -> str.regionMatches(true, i, substring, 0, substringLength));
    }
}

