/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.net.InetAddress;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.script.AbstractFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptFactory;
import org.elasticsearch.search.lookup.SearchLookup;

public abstract class IpFieldScript
extends AbstractFieldScript {
    public static final ScriptContext<Factory> CONTEXT = IpFieldScript.newContext("ip_field", Factory.class);
    public static final Factory PARSE_FROM_SOURCE = new Factory(){

        @Override
        public LeafFactory newFactory(String field, Map<String, Object> params, SearchLookup lookup, OnScriptError onScriptError) {
            return ctx -> new IpFieldScript(this, field, params, lookup, OnScriptError.FAIL, ctx){

                @Override
                public void execute() {
                    this.emitFromSource();
                }
            };
        }

        @Override
        public boolean isResultDeterministic() {
            return true;
        }

        @Override
        public boolean isParsedFromSource() {
            return true;
        }
    };
    public static final String[] PARAMETERS = new String[0];
    private BytesRef[] values = new BytesRef[1];
    private int count;

    public static Factory leafAdapter(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentFactory) {
        return (leafFieldName, params, searchLookup, onScriptError) -> {
            CompositeFieldScript.LeafFactory parentLeafFactory = (CompositeFieldScript.LeafFactory)parentFactory.apply(searchLookup);
            return ctx -> {
                final CompositeFieldScript compositeFieldScript = parentLeafFactory.newInstance(ctx);
                return new IpFieldScript(leafFieldName, params, searchLookup, onScriptError, ctx){

                    @Override
                    public void setDocument(int docId) {
                        compositeFieldScript.setDocument(docId);
                    }

                    @Override
                    public void execute() {
                        this.emitFromCompositeScript(compositeFieldScript);
                    }
                };
            };
        };
    }

    public IpFieldScript(String fieldName, Map<String, Object> params, SearchLookup searchLookup, OnScriptError onScriptError, LeafReaderContext ctx) {
        super(fieldName, params, searchLookup, ctx, onScriptError);
    }

    @Override
    protected void prepareExecute() {
        this.count = 0;
    }

    public final void runForDoc(int docId, Consumer<InetAddress> consumer) {
        this.runForDoc(docId);
        for (int i = 0; i < this.count; ++i) {
            consumer.accept(InetAddressPoint.decode((byte[])this.values[i].bytes));
        }
    }

    public final BytesRef[] values() {
        return this.values;
    }

    public final int count() {
        return this.count;
    }

    @Override
    protected void emitFromObject(Object v) {
        if (v instanceof String) {
            try {
                this.emit((String)v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final void emit(String v) {
        if (this.values.length < this.count + 1) {
            this.values = (BytesRef[])ArrayUtil.grow((Object[])this.values, (int)(this.count + 1));
        }
        BytesRef encoded = new BytesRef(InetAddressPoint.encode((InetAddress)InetAddresses.forString(v)));
        this.values[this.count++] = encoded;
    }

    public static interface Factory
    extends ScriptFactory {
        public LeafFactory newFactory(String var1, Map<String, Object> var2, SearchLookup var3, OnScriptError var4);
    }

    public static interface LeafFactory {
        public IpFieldScript newInstance(LeafReaderContext var1);
    }

    public static class Emit {
        private final IpFieldScript script;

        public Emit(IpFieldScript script) {
            this.script = script;
        }

        public void emit(String v) {
            this.script.checkMaxSize(this.script.count());
            this.script.emit(v);
        }
    }
}

