/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.index.fielddata.NumericDoubleValues;

final class SortableLongBitsToNumericDoubleValues
extends NumericDoubleValues {
    private final LongValues values;

    SortableLongBitsToNumericDoubleValues(LongValues values) {
        this.values = values;
    }

    public double doubleValue() throws IOException {
        return NumericUtils.sortableLongToDouble((long)this.values.longValue());
    }

    public boolean advanceExact(int doc) throws IOException {
        return this.values.advanceExact(doc);
    }

    public LongValues getLongValues() {
        return this.values;
    }
}

