/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.io.IOException;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.index.fielddata.NumericDoubleValues;

final class SortableLongBitsNumericDocValues
extends LongValues {
    private final NumericDoubleValues values;

    SortableLongBitsNumericDocValues(NumericDoubleValues values) {
        this.values = values;
    }

    public long longValue() throws IOException {
        return NumericUtils.doubleToSortableLong((double)this.values.doubleValue());
    }

    public boolean advanceExact(int target) throws IOException {
        return this.values.advanceExact(target);
    }

    public NumericDoubleValues getDoubleValues() {
        return this.values;
    }
}

